/*
 * Copyright 2018-2021 guerlab.net and other contributors.
 *
 * Licensed under the GNU LESSER GENERAL PUBLIC LICENSE, Version 3 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.guerlab.smart.dingtalk.web.domain;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

/**
 * 绑定信息
 *
 * @author guer
 */
@Data
@Schema(description = "绑定信息")
public class BindRequest {

    /**
     * 用户名
     */
    @Schema(description = "用户名")
    private String username;

    /**
     * 密码
     */
    @Schema(description = "密码")
    private String password;

    /**
     * 第三方ID
     */
    @Schema(description = "第三方ID")
    private String thirdPartyId;
}
