/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.dingtalk.web.controller.user;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import javax.servlet.http.HttpServletRequest;
import net.guerlab.commons.exception.ApplicationException;
import net.guerlab.sdk.dingtalk.client.DingTalkClient;
import net.guerlab.sdk.dingtalk.request.AbstractDingTalkRequest;
import net.guerlab.sdk.dingtalk.request.AbstractSnsRequest;
import net.guerlab.sdk.dingtalk.request.sns.GetUserInfoByCodeRequest;
import net.guerlab.sdk.dingtalk.request.user.GetUserIdByUnionIdRequest;
import net.guerlab.sdk.dingtalk.response.sns.GetUserInfoByCodeResponse;
import net.guerlab.sdk.dingtalk.response.user.GetUserIdByUnionIdResponse;
import net.guerlab.smart.dingtalk.web.controller.AbstractDingTalkControlPanelController;
import net.guerlab.smart.platform.auth.annotation.IgnoreLogin;
import net.guerlab.smart.user.core.domain.UserDTO;
import net.guerlab.smart.user.core.entity.OauthLoginResponse;
import net.guerlab.smart.user.core.exception.NotOauthGroupAllowUserException;
import net.guerlab.smart.user.core.exception.UnsupportedLoginTypeException;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="\u9489\u9489Oauth-\u63a7\u5236\u9762\u677f")
@RestController(value="/user/dingTalkOauth/controlPanel")
@RequestMapping(value={"/user/dingTalkOauth/controlPanel"})
public class DingTalkOauthControlPanelController
extends AbstractDingTalkControlPanelController {
    @IgnoreLogin
    @Operation(summary="\u901a\u8fc7qrCode\u767b\u5f55")
    @GetMapping(value={"/{appKey}/loginByQrCode"})
    public OauthLoginResponse loginByQrCode(@Parameter(description="appKey", required=true) @PathVariable String appKey, @Parameter(description="code", required=true) @RequestParam String code, HttpServletRequest request) {
        DingTalkClient client = this.dingTalkClientManagerService.getClient(appKey);
        if (client == null) {
            throw new UnsupportedLoginTypeException();
        }
        GetUserInfoByCodeResponse.UserInfo userInfo = this.getDingTalkUserInfo(client, code);
        String unionId = userInfo.getUnionId();
        if (unionId == null) {
            throw new NotOauthGroupAllowUserException();
        }
        String userId = this.getDingTalkUserId(client, unionId);
        String type = this.getOauthType(appKey);
        UserDTO user = this.findUser(client, type, userId);
        return this.getLoginSucceedDTO(user, userId, request, type);
    }

    private GetUserInfoByCodeResponse.UserInfo getDingTalkUserInfo(DingTalkClient client, String code) {
        GetUserInfoByCodeRequest request = new GetUserInfoByCodeRequest();
        request.setTmpAuthCode(code);
        GetUserInfoByCodeResponse response = (GetUserInfoByCodeResponse)client.execute((AbstractSnsRequest)request);
        if (response.getErrcode() > 0) {
            throw new ApplicationException(response.getErrmsg(), response.getErrcode());
        }
        return response.getUserInfo();
    }

    private String getDingTalkUserId(DingTalkClient client, String unionId) {
        GetUserIdByUnionIdRequest request = new GetUserIdByUnionIdRequest();
        request.setUnionId(unionId);
        GetUserIdByUnionIdResponse response = (GetUserIdByUnionIdResponse)client.execute((AbstractDingTalkRequest)request);
        if (response.getErrcode() > 0) {
            throw new ApplicationException(response.getErrmsg(), response.getErrcode());
        }
        return response.getUserId();
    }

    protected String getOauthTypePrefix() {
        return "DING_TALK_OAUTH";
    }
}

