/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.dingtalk.web.controller.user;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import javax.servlet.http.HttpServletRequest;
import net.guerlab.commons.exception.ApplicationException;
import net.guerlab.sdk.dingtalk.client.DingTalkClient;
import net.guerlab.sdk.dingtalk.request.AbstractDingTalkRequest;
import net.guerlab.sdk.dingtalk.request.user.UserGetUserInfoRequest;
import net.guerlab.sdk.dingtalk.response.user.UserGetUserInfoResponse;
import net.guerlab.smart.dingtalk.web.controller.AbstractDingTalkControlPanelController;
import net.guerlab.smart.platform.auth.annotation.IgnoreLogin;
import net.guerlab.smart.user.core.domain.UserDTO;
import net.guerlab.smart.user.core.entity.OauthLoginResponse;
import net.guerlab.smart.user.core.exception.NotOauthGroupAllowUserException;
import net.guerlab.smart.user.core.exception.UnsupportedLoginTypeException;
import org.apache.commons.lang3.StringUtils;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="\u9489\u9489-\u63a7\u5236\u9762\u677f")
@RestController(value="/user/dingTalk/controlPanel")
@RequestMapping(value={"/user/dingTalk/controlPanel"})
public class DingTalkControlPanelController
extends AbstractDingTalkControlPanelController {
    @IgnoreLogin
    @Operation(summary="\u901a\u8fc7code\u767b\u5f55")
    @GetMapping(value={"/{appKey}/loginByCode"})
    @Transactional(rollbackFor={Exception.class})
    public OauthLoginResponse loginByCode(@Parameter(description="appKey", required=true) @PathVariable String appKey, @Parameter(description="code", required=true) @RequestParam String code, HttpServletRequest request) {
        DingTalkClient client = this.dingTalkClientManagerService.getClient(appKey);
        if (client == null) {
            throw new UnsupportedLoginTypeException();
        }
        UserGetUserInfoResponse response = this.getDingTalkUserInfo(client, code);
        String userId = response.getUserId();
        if (StringUtils.isBlank((CharSequence)userId)) {
            throw new NotOauthGroupAllowUserException();
        }
        String type = this.getOauthType(appKey);
        UserDTO user = this.findUser(client, type, userId);
        return this.getLoginSucceedDTO(user, userId, request, type);
    }

    private UserGetUserInfoResponse getDingTalkUserInfo(DingTalkClient client, String code) {
        UserGetUserInfoRequest request = new UserGetUserInfoRequest();
        request.setCode(code);
        UserGetUserInfoResponse response = (UserGetUserInfoResponse)client.execute((AbstractDingTalkRequest)request);
        if (response.getErrcode() > 0) {
            throw new ApplicationException(response.getErrmsg(), response.getErrcode());
        }
        return response;
    }

    protected String getOauthTypePrefix() {
        return "DING_TALK";
    }
}

