/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.dingtalk.web.controller;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import net.guerlab.commons.exception.ApplicationException;
import net.guerlab.commons.number.NumberHelper;
import net.guerlab.sdk.dingtalk.client.DingTalkClient;
import net.guerlab.sdk.dingtalk.request.AbstractDingTalkRequest;
import net.guerlab.sdk.dingtalk.request.user.GetUserRequest;
import net.guerlab.sdk.dingtalk.response.user.GetUserResponse;
import net.guerlab.smart.dingtalk.service.service.DingTalkClientManagerService;
import net.guerlab.smart.dingtalk.web.domain.BindRequest;
import net.guerlab.smart.platform.auth.annotation.IgnoreLogin;
import net.guerlab.smart.platform.commons.exception.PasswordErrorException;
import net.guerlab.smart.platform.commons.exception.ThirdPartyIdInvalidException;
import net.guerlab.smart.platform.commons.ip.IpUtils;
import net.guerlab.smart.user.api.OauthApi;
import net.guerlab.smart.user.api.UserApi;
import net.guerlab.smart.user.auth.UserContextHandler;
import net.guerlab.smart.user.core.domain.OauthDTO;
import net.guerlab.smart.user.core.domain.UserDTO;
import net.guerlab.smart.user.core.entity.OauthLoginResponse;
import net.guerlab.smart.user.core.entity.UserInternalLoginRequest;
import net.guerlab.smart.user.core.exception.UnsupportedLoginTypeException;
import net.guerlab.smart.user.core.exception.UserHasBoundException;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

public abstract class AbstractDingTalkControlPanelController {
    protected DingTalkClientManagerService dingTalkClientManagerService;
    protected OauthApi oauthApi;
    protected UserApi userApi;

    protected UserDTO findUser(DingTalkClient client, String type, String thirdPartyId) {
        Optional oauthOptional = this.oauthApi.findOneOptional(type, thirdPartyId);
        if (oauthOptional.isEmpty()) {
            return null;
        }
        OauthDTO oauth = (OauthDTO)oauthOptional.get();
        Long userId = oauth.getUserId();
        if (NumberHelper.greaterZero((Number)userId)) {
            return this.userApi.findOne(oauth.getUserId());
        }
        GetUserResponse dingTalkUser = this.getDingTalkUser(client, thirdPartyId);
        String phone = StringUtils.trimToNull((String)dingTalkUser.getMobile());
        if (phone == null) {
            return null;
        }
        return this.userApi.findOneByPhoneOptional(phone).orElse(null);
    }

    protected UserDTO getUser(String type, String thirdPartyId) {
        Optional oauthOptional = this.oauthApi.findOneOptional(type, thirdPartyId);
        if (oauthOptional.isEmpty() || !NumberHelper.greaterZero((Number)((OauthDTO)oauthOptional.get()).getUserId())) {
            return null;
        }
        return this.userApi.findOne(((OauthDTO)oauthOptional.get()).getUserId());
    }

    protected GetUserResponse getDingTalkUser(DingTalkClient client, String userId) {
        GetUserRequest request = new GetUserRequest();
        request.setUserId(userId);
        GetUserResponse response = (GetUserResponse)client.execute((AbstractDingTalkRequest)request);
        if (response.getErrcode() > 0) {
            throw new ApplicationException(response.getErrmsg(), response.getErrcode());
        }
        return response;
    }

    @IgnoreLogin
    @Operation(summary="\u7ed1\u5b9a")
    @PostMapping(value={"/{appKey}/bind"})
    public OauthLoginResponse bind(@Parameter(description="type", required=true) @PathVariable String appKey, @RequestBody BindRequest bindRequest, HttpServletRequest request) {
        String type = this.getOauthType(appKey);
        String thirdPartyId = StringUtils.trimToNull((String)bindRequest.getThirdPartyId());
        if (thirdPartyId == null) {
            throw new ThirdPartyIdInvalidException();
        }
        if (this.getUser(type, thirdPartyId) != null) {
            throw new UserHasBoundException();
        }
        UserDTO user = this.userApi.findOneByUsername(bindRequest.getUsername());
        if (this.oauthApi.findOneOptional(type, user.getUserId()).isPresent()) {
            throw new UserHasBoundException();
        }
        if (!this.userApi.checkPassword(user.getUserId(), bindRequest.getPassword())) {
            throw new PasswordErrorException();
        }
        this.oauthApi.bind(user.getUserId(), type, thirdPartyId);
        return this.getLoginSucceedDTO(user, thirdPartyId, request, type);
    }

    @Operation(summary="\u89e3\u7ed1", security={@SecurityRequirement(name="Authorization")})
    @PostMapping(value={"/{appKey}/unbind"})
    public void bind(@Parameter(description="type", required=true) @PathVariable String appKey) {
        this.oauthApi.unbind(UserContextHandler.getUserId(), this.getOauthType(appKey));
    }

    @Operation(summary="\u83b7\u53d6\u7ed1\u5b9a\u72b6\u6001", security={@SecurityRequirement(name="Authorization")})
    @GetMapping(value={"/{appKey}/bindStatus"})
    public boolean bindStatus(@Parameter(description="type", required=true) @PathVariable String appKey) {
        return this.oauthApi.findOneOptional(this.getOauthType(appKey), UserContextHandler.getUserId()).isPresent();
    }

    protected String getOauthType(String appKey) {
        if ((appKey = StringUtils.trimToNull((String)appKey)) == null) {
            throw new UnsupportedLoginTypeException();
        }
        return this.getOauthTypePrefix() + "_" + appKey;
    }

    protected abstract String getOauthTypePrefix();

    protected OauthLoginResponse getLoginSucceedDTO(UserDTO user, String openId, HttpServletRequest request, String loginType) {
        String ip = IpUtils.getIp((HttpServletRequest)request);
        OauthLoginResponse oauthLoginResponse = new OauthLoginResponse();
        if (user != null) {
            UserInternalLoginRequest loginRequest = new UserInternalLoginRequest();
            loginRequest.setIp(ip);
            loginRequest.setUserId(user.getUserId());
            loginRequest.setLoginType(loginType);
            BeanUtils.copyProperties((Object)this.userApi.internalLogin(loginRequest), (Object)oauthLoginResponse);
        }
        OauthDTO oauth = new OauthDTO();
        oauth.setUserId(user == null ? null : user.getUserId());
        oauth.setType(loginType);
        oauth.setThirdPartyId(openId);
        oauthLoginResponse.setThirdParty(oauth);
        return oauthLoginResponse;
    }

    @Autowired
    public void setDingTalkClientManagerService(DingTalkClientManagerService dingTalkClientManagerService) {
        this.dingTalkClientManagerService = dingTalkClientManagerService;
    }

    @Autowired
    public void setOauthApi(OauthApi oauthApi) {
        this.oauthApi = oauthApi;
    }

    @Autowired
    public void setUserApi(UserApi userApi) {
        this.userApi = userApi;
    }
}

