package net.guerlab.smart.dingtalk.web.controller.user;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import net.guerlab.commons.exception.ApplicationException;
import net.guerlab.smart.dingtalk.core.domain.DingTalkAppDTO;
import net.guerlab.smart.dingtalk.core.enums.DingTalkAppType;
import net.guerlab.smart.dingtalk.core.exception.DingTalkAppInvalidException;
import net.guerlab.smart.dingtalk.core.searchparams.DingTalkAppSearchParams;
import net.guerlab.smart.dingtalk.service.entity.DingTalkApp;
import net.guerlab.smart.dingtalk.service.service.DingTalkAppService;
import net.guerlab.smart.dingtalk.service.service.DingTalkClientManagerService;
import net.guerlab.smart.platform.server.controller.BaseController;
import net.guerlab.smart.platform.user.api.OperationLogApi;
import net.guerlab.smart.platform.user.auth.UserContextHandler;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 钉钉应用
 *
 * @author guer
 */
@Api(tags = "钉钉应用")
@RestController("/user/dingTalkApp")
@RequestMapping("/user/dingTalkApp")
public class DingTalkAppController extends BaseController<DingTalkAppDTO, DingTalkApp, DingTalkAppService, DingTalkAppSearchParams, String> {

    private DingTalkClientManagerService managerService;

    private OperationLogApi operationLogApi;

    @Override
    protected ApplicationException nullPointException() {
        return new DingTalkAppInvalidException();
    }

    @Override
    public void copyProperties(DingTalkAppDTO dto, DingTalkApp entity, String id) {
        DingTalkAppType appType = entity.getAppType();
        super.copyProperties(dto, entity, id);
        if (id == null) {
            return;
        }
        entity.setAppKey(id);
        entity.setAppType(appType);
    }

    @ApiOperation("移除Token缓存")
    @PostMapping("/{appKey}/removeTokenCache")
    public void removeTokenCache(@ApiParam(value = "appKey", required = true) @PathVariable String appKey) {
        DingTalkApp app = findOne0(appKey);

        managerService.getClient(appKey).getDingTalkConfigStorage().expireAccessToken();

        operationLogApi.add("移除Token缓存", UserContextHandler.getUserId(), app);
    }

    @Override
    public void afterSave(DingTalkApp entity, DingTalkAppDTO dto) {
       operationLogApi.add("添加钉钉应用", UserContextHandler.getUserId(), entity);
    }

    @Override
    public void afterUpdate(DingTalkApp entity, DingTalkAppDTO dto) {
        operationLogApi.add("编辑钉钉应用", UserContextHandler.getUserId(), entity);
    }

    @Override
    public void afterDelete(DingTalkApp entity) {
        operationLogApi.add("删除钉钉应用", UserContextHandler.getUserId(), entity.getAppKey());
    }

    @Autowired
    public void setManagerService(DingTalkClientManagerService managerService) {
        this.managerService = managerService;
    }

    @SuppressWarnings("SpringJavaInjectionPointsAutowiringInspection")
    @Autowired
    public void setOperationLogApi(OperationLogApi operationLogApi) {
        this.operationLogApi = operationLogApi;
    }

}
