/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.dingtalk.internal.inside;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import net.guerlab.commons.exception.ApplicationException;
import net.guerlab.sdk.dingtalk.client.DingTalkClient;
import net.guerlab.sdk.dingtalk.request.AbstractDingTalkRequest;
import net.guerlab.sdk.dingtalk.request.AbstractSnsRequest;
import net.guerlab.sdk.dingtalk.request.sns.GetUserInfoByCodeRequest;
import net.guerlab.sdk.dingtalk.request.user.GetUserIdByMobileRequest;
import net.guerlab.sdk.dingtalk.request.user.GetUserIdByUnionIdRequest;
import net.guerlab.sdk.dingtalk.request.user.GetUserRequest;
import net.guerlab.sdk.dingtalk.request.user.UserGetUserInfoRequest;
import net.guerlab.sdk.dingtalk.response.sns.GetUserInfoByCodeResponse;
import net.guerlab.sdk.dingtalk.response.user.GetUserIdByMobileResponse;
import net.guerlab.sdk.dingtalk.response.user.GetUserIdByUnionIdResponse;
import net.guerlab.sdk.dingtalk.response.user.GetUserResponse;
import net.guerlab.sdk.dingtalk.response.user.UserGetUserInfoResponse;
import net.guerlab.smart.dingtalk.core.domain.DingTalkUserDTO;
import net.guerlab.smart.dingtalk.core.domain.DingTalkUserIdInfoDTO;
import net.guerlab.smart.dingtalk.core.domain.DingTalkUserInfoDTO;
import net.guerlab.smart.dingtalk.core.domain.DingTalkUserOauthInfoDTO;
import net.guerlab.smart.dingtalk.service.service.DingTalkClientManagerService;
import net.guerlab.web.result.Result;
import net.guerlab.web.result.Succeed;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="\u9489\u9489\u5ba2\u6237\u7aef")
@RestController(value="/inside/dingTalkClient")
@RequestMapping(value={"/inside/dingTalkClient/{appKey}"})
public class DingTalkClientController {
    private DingTalkClientManagerService managerService;

    @Operation(description="\u83b7\u53d6accessToken")
    @GetMapping(value={"/accessToken"})
    public Result<String> getAccessToken(@Parameter(description="appKey", required=true) @PathVariable String appKey) {
        return new Succeed("success", (Object)this.getClient(appKey).getAccessToken());
    }

    @Operation(description="\u901a\u8fc7code\u83b7\u53d6\u7528\u6237\u4fe1\u606f")
    @GetMapping(value={"/user/getUserInfo/{code}"})
    public DingTalkUserInfoDTO getDingTalkUserInfo(@Parameter(description="appKey", required=true) @PathVariable String appKey, @Parameter(description="code", required=true) @PathVariable String code) {
        UserGetUserInfoRequest request = new UserGetUserInfoRequest();
        request.setCode(code);
        UserGetUserInfoResponse response = (UserGetUserInfoResponse)this.getClient(appKey).execute((AbstractDingTalkRequest)request);
        if (response.getErrcode() > 0) {
            throw new ApplicationException(response.getErrmsg(), response.getErrcode());
        }
        DingTalkUserInfoDTO result = new DingTalkUserInfoDTO();
        result.setIsSys(Boolean.valueOf(response.isSys()));
        result.setSysLevel(Integer.valueOf(response.getSysLevel()));
        result.setUserId(response.getUserId());
        return result;
    }

    @Operation(description="\u901a\u8fc7code\u83b7\u53d6\u7528\u6237Oauth\u4fe1\u606f")
    @GetMapping(value={"/user/getUserInfoByCode/{code}"})
    public DingTalkUserOauthInfoDTO getDingTalkUserInfoByCode(@Parameter(description="appKey", required=true) @PathVariable String appKey, @Parameter(description="code", required=true) @PathVariable String code) {
        GetUserInfoByCodeRequest request = new GetUserInfoByCodeRequest();
        request.setTmpAuthCode(code);
        GetUserInfoByCodeResponse response = (GetUserInfoByCodeResponse)this.getClient(appKey).execute((AbstractSnsRequest)request);
        if (response.getErrcode() > 0) {
            throw new ApplicationException(response.getErrmsg(), response.getErrcode());
        }
        GetUserInfoByCodeResponse.UserInfo userInfo = response.getUserInfo();
        DingTalkUserOauthInfoDTO result = new DingTalkUserOauthInfoDTO();
        result.setNick(userInfo.getNick());
        result.setOpenId(userInfo.getOpenId());
        result.setUnionId(userInfo.getUnionId());
        return result;
    }

    @Operation(description="\u901a\u8fc7unionId\u83b7\u53d6\u7528\u6237id")
    @GetMapping(value={"/user/getUserIdByUnionId/{unionId}"})
    public DingTalkUserIdInfoDTO getUserIdByUnionId(@Parameter(description="appKey", required=true) @PathVariable String appKey, @Parameter(description="unionId", required=true) @PathVariable String unionId) {
        GetUserIdByUnionIdRequest request = new GetUserIdByUnionIdRequest();
        request.setUnionId(unionId);
        GetUserIdByUnionIdResponse response = (GetUserIdByUnionIdResponse)this.getClient(appKey).execute((AbstractDingTalkRequest)request);
        if (response.getErrcode() > 0) {
            throw new ApplicationException(response.getErrmsg(), response.getErrcode());
        }
        DingTalkUserIdInfoDTO result = new DingTalkUserIdInfoDTO();
        result.setUserId(response.getUserId());
        result.setContactType(Integer.valueOf(response.getContactType()));
        return result;
    }

    @Operation(description="\u901a\u8fc7\u7535\u8bdd\u53f7\u7801\u83b7\u53d6\u7528\u6237id")
    @GetMapping(value={"/user/getUserIdByMobile/{mobile}"})
    public Result<String> getUserIdByMobile(@Parameter(description="appKey", required=true) @PathVariable String appKey, @Parameter(description="mobile", required=true) @PathVariable String mobile) {
        GetUserIdByMobileRequest request = new GetUserIdByMobileRequest();
        request.setMobile(mobile);
        GetUserIdByMobileResponse response = (GetUserIdByMobileResponse)this.getClient(appKey).execute((AbstractDingTalkRequest)request);
        if (response.getErrcode() > 0) {
            throw new ApplicationException(response.getErrmsg(), response.getErrcode());
        }
        return new Succeed("success", (Object)response.getUserId());
    }

    @Operation(description="\u83b7\u53d6\u7528\u6237")
    @GetMapping(value={"/user/getUser/{userId}"})
    public DingTalkUserDTO getUser(@Parameter(description="appKey", required=true) @PathVariable String appKey, @Parameter(description="userId", required=true) @PathVariable String userId) {
        GetUserRequest request = new GetUserRequest();
        request.setUserId(userId);
        GetUserResponse response = (GetUserResponse)this.getClient(appKey).execute((AbstractDingTalkRequest)request);
        if (response.getErrcode() > 0) {
            throw new ApplicationException(response.getErrmsg(), response.getErrcode());
        }
        DingTalkUserDTO result = new DingTalkUserDTO();
        BeanUtils.copyProperties((Object)response, (Object)result);
        return result;
    }

    private DingTalkClient getClient(String appKey) {
        return this.managerService.getClient(appKey);
    }

    @Autowired
    public void setManagerService(DingTalkClientManagerService managerService) {
        this.managerService = managerService;
    }
}

