/*
 * Copyright 2018-2021 guerlab.net and other contributors.
 *
 * Licensed under the GNU LESSER GENERAL PUBLIC LICENSE, Version 3 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.guerlab.smart.dingtalk.internal.inside;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import net.guerlab.smart.dingtalk.core.domain.DingTalkAppDTO;
import net.guerlab.smart.dingtalk.core.exception.DingTalkAppInvalidException;
import net.guerlab.smart.dingtalk.core.searchparams.DingTalkAppSearchParams;
import net.guerlab.smart.dingtalk.service.service.DingTalkAppService;
import net.guerlab.smart.platform.commons.util.BeanConvertUtils;
import net.guerlab.web.result.ListObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.Collection;

/**
 * 钉钉应用
 *
 * @author guer
 */
@Tag(name = "钉钉应用")
@RestController("/inside/dingTalkApp")
@RequestMapping("/inside/dingTalkApp")
public class DingTalkAppController {

    private DingTalkAppService service;

    @Operation(description = "根据应用key查询钉钉应用")
    @GetMapping("/{appKey}")
    public DingTalkAppDTO findOne(@Parameter(description = "appKey", required = true) @PathVariable String appKey) {
        return service.selectByIdOptional(appKey).orElseThrow(DingTalkAppInvalidException::new).convert();
    }

    @Operation(description = "根据搜索条件查询钉钉应用分页列表")
    @PostMapping
    public ListObject<DingTalkAppDTO> findList(@RequestBody DingTalkAppSearchParams searchParams) {
        return BeanConvertUtils.toListObject(service.selectPage(searchParams));
    }

    @Operation(description = "根据搜索条件查询钉钉应用列表")
    @PostMapping("/all")
    public Collection<DingTalkAppDTO> findAll(@RequestBody DingTalkAppSearchParams searchParams) {
        return BeanConvertUtils.toList(service.selectAll(searchParams));
    }

    @Autowired
    public void setService(DingTalkAppService service) {
        this.service = service;
    }
}
