package net.guerlab.smart.dingtalk.internal.inside;

import io.swagger.annotations.ApiParam;
import net.guerlab.smart.dingtalk.core.domain.DingTalkAppDTO;
import net.guerlab.smart.dingtalk.core.exception.DingTalkAppInvalidException;
import net.guerlab.smart.dingtalk.core.searchparams.DingTalkAppSearchParams;
import net.guerlab.smart.dingtalk.service.service.DingTalkAppService;
import net.guerlab.smart.platform.commons.util.BeanConvertUtils;
import net.guerlab.web.result.ListObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.Collection;

/**
 * 钉钉应用
 *
 * @author guer
 */
@RestController("/inside/dingTalkApp")
@RequestMapping("/inside/dingTalkApp")
public class DingTalkAppController {

    private DingTalkAppService service;

    @GetMapping("/{appKey}")
    public DingTalkAppDTO findOne(@ApiParam(value = "appKey", required = true) @PathVariable String appKey) {
        return service.selectByIdOptional(appKey).orElseThrow(DingTalkAppInvalidException::new).toDTO();
    }

    @PostMapping
    public ListObject<DingTalkAppDTO> findList(@RequestBody DingTalkAppSearchParams searchParams) {
        return BeanConvertUtils.toListObject(service.selectPage(searchParams));
    }

    @PostMapping("/all")
    public Collection<DingTalkAppDTO> findAll(@RequestBody DingTalkAppSearchParams searchParams) {
        return BeanConvertUtils.toList(service.selectAll(searchParams));
    }

    @Autowired
    public void setService(DingTalkAppService service) {
        this.service = service;
    }
}
