/*
 * Copyright 2018-2021 guerlab.net and other contributors.
 *
 * Licensed under the GNU LESSER GENERAL PUBLIC LICENSE, Version 3 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.guerlab.smart.dingtalk.core.domain;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

/**
 * 钉钉用户Oauth信息
 * @author guer
 */
@Data
@Schema(name = "DingTalkUserOauthInfoDTO", description = "钉钉用户Oauth信息")
public class DingTalkUserOauthInfoDTO {

    /**
     * 用户在钉钉上面的昵称
     */
    @Schema(description = "用户在钉钉上面的昵称")
    private String nick;

    /**
     * 用户在当前开放应用内的唯一标识
     */
    @Schema(description = "用户在当前开放应用内的唯一标识")
    private String openId;

    /**
     * 用户在当前开放应用所属企业的唯一标识
     */
    @Schema(description = "用户在当前开放应用所属企业的唯一标识")
    private String unionId;
}
