/*
 * Copyright 2018-2021 guerlab.net and other contributors.
 *
 * Licensed under the GNU LESSER GENERAL PUBLIC LICENSE, Version 3 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.guerlab.smart.dingtalk.core.domain;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;

/**
 * 钉钉用户
 *
 * @author guer
 */
@Data
@Schema(name = "DingTalkUserDTO", description = "钉钉用户")
public class DingTalkUserDTO {

    /**
     * 员工在当前企业内的唯一标识，也称staffId。可由企业在创建时指定，并代表一定含义比如工号，创建后不可修改
     */
    @Schema(description = "员工在当前企业内的唯一标识")
    private String userId;

    /**
     * 员工在当前开发者企业账号范围内的唯一标识，系统生成，固定值，不会改变
     */
    @Schema(description = "员工在当前开发者企业账号范围内的唯一标识")
    private String unionId;

    /**
     * 员工名字
     */
    @Schema(description = "员工名字")
    private String name;

    /**
     * 分机号（仅限企业内部开发调用）
     */
    @Schema(description = "分机号")
    private String tel;

    /**
     * 办公地点
     */
    @Schema(description = "办公地点")
    private String workPlace;

    /**
     * 备注
     */
    @Schema(description = "备注")
    private String remark;

    /**
     * 手机号码
     */
    @Schema(description = "手机号码")
    private String mobile;

    /**
     * 员工的电子邮箱
     */
    @Schema(description = "员工的电子邮箱")
    private String email;

    /**
     * 员工的企业邮箱，如果员工已经开通了企业邮箱，接口会返回，否则不会返回
     */
    @Schema(description = "员工的企业邮箱")
    private String orgEmail;

    /**
     * 是否已经激活
     */
    @Schema(description = "是否已经激活")
    private Boolean active;

    /**
     * 是否为企业的管理员
     */
    @Schema(description = "是否为企业的管理员")
    private Boolean isAdmin;

    /**
     * 是否为企业的老板
     */
    @Schema(description = "是否为企业的老板")
    private Boolean isBoss;

    /**
     * 是否号码隐藏
     */
    @Schema(description = "是否号码隐藏")
    private Boolean isHide;

    /**
     * 成员所属部门id列表
     */
    @Schema(description = "成员所属部门id列表")
    private List<Long> department;

    /**
     * 职位信息
     */
    @Schema(description = "职位信息")
    private String position;

    /**
     * 头像url
     */
    @Schema(description = "头像url")
    private String avatar;

    /**
     * 入职时间
     */
    @Schema(description = "入职时间")
    private LocalDateTime hiredDate;

    /**
     * 员工工号
     */
    @Schema(description = "员工工号")
    private String jobNumber;

    /**
     * 扩展属性
     */
    @Schema(description = "扩展属性")
    private Map<String, String> extAttr;

    /**
     * 是否是高管
     */
    @Schema(description = "是否是高管")
    private String isSenior;

    /**
     * 国家地区码
     */
    @Schema(description = "国家地区码")
    private String stateCode;

    /**
     * 是否实名认证
     */
    @Schema(description = "是否实名认证")
    private Boolean realAuthed;
}
