/*
 * Copyright 2018-2021 guerlab.net and other contributors.
 *
 * Licensed under the GNU LESSER GENERAL PUBLIC LICENSE, Version 3 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.guerlab.smart.dingtalk.core.searchparams;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.Setter;
import net.guerlab.smart.dingtalk.core.enums.DingTalkAppType;
import net.guerlab.smart.platform.commons.searchparams.OrderSearchParams;
import net.guerlab.spring.searchparams.SearchModel;
import net.guerlab.spring.searchparams.SearchModelType;

import javax.persistence.Column;

/**
 * 钉钉应用搜索参数
 *
 * @author guer
 */
@Setter
@Getter
@Schema(name = "DingTalkAppSearchParams", description = "钉钉应用搜索参数")
public class DingTalkAppSearchParams extends OrderSearchParams {

    /**
     * 应用key
     */
    @Schema(description = "应用key")
    private String appKey;

    /**
     * 企业ID
     */
    @Schema(description = "企业ID")
    private String corpId;

    /**
     * 应用类型
     */
    @Schema(description = "应用类型")
    private DingTalkAppType appType;

    /**
     * 应用名称关键字
     */
    @Schema(description = "应用名称关键字")
    @Column(name = "appName")
    @SearchModel(SearchModelType.LIKE)
    private String appNameLike;

    /**
     * 启用标志
     */
    @Schema(description = "启用标志")
    private Boolean enabled;
}
