/*
 * Copyright 2018-2021 guerlab.net and other contributors.
 *
 * Licensed under the GNU LESSER GENERAL PUBLIC LICENSE, Version 3 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.guerlab.smart.dingtalk.core.domain;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

/**
 * 钉钉用户信息
 * @author guer
 */
@Data
@Schema(name = "DingTalkUserInfoDTO", description = "钉钉用户信息")
public class DingTalkUserInfoDTO {

    /**
     * 用户ID
     */
    @Schema(description = "用户ID")
    private String userId;

    /**
     * 级别。1是主管理员，2是子管理员，100是老板，0是其他（如普通员工）
     */
    @Schema(description = "级别")
    private Integer sysLevel;

    /**
     * 是否是管理员，true：是，false：不是
     */
    @Schema(description = "用户ID")
    private Boolean isSys;
}
