/*
 * Copyright 2018-2021 guerlab.net and other contributors.
 *
 * Licensed under the GNU LESSER GENERAL PUBLIC LICENSE, Version 3 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.guerlab.smart.dingtalk.core.domain;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

/**
 * 钉钉用户userId信息
 *
 * @author guer
 */
@Data
@Schema(name = "DingTalkUserIdInfoDTO", description = "钉钉用户userId信息")
public class DingTalkUserIdInfoDTO {

    /**
     * 员工id
     */
    @Schema(description = "员工id")
    private String userId;

    /**
     * 联系类型，0表示企业内部员工，1表示企业外部联系人
     */
    @Schema(description = "联系类型，0表示企业内部员工，1表示企业外部联系人")
    private Integer contactType;
}
