/*
 * Copyright 2018-2021 guerlab.net and other contributors.
 *
 * Licensed under the GNU LESSER GENERAL PUBLIC LICENSE, Version 3 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.guerlab.smart.dingtalk.core.domain;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import net.guerlab.smart.dingtalk.core.enums.DingTalkAppType;

import java.time.LocalDateTime;

/**
 * 钉钉应用
 *
 * @author guer
 */
@Data
@Schema(name = "DingTalkAppDTO", description = "钉钉应用")
public class DingTalkAppDTO {

    /**
     * 应用key
     */
    @Schema(description = "应用key")
    private String appKey;

    /**
     * 企业ID
     */
    @Schema(description = "企业ID")
    private String corpId;

    /**
     * 应用密钥
     */
    @Schema(description = "应用密钥")
    private String appSecret;

    /**
     * 应用类型
     */
    @Schema(description = "应用类型")
    private DingTalkAppType appType;

    /**
     * 应用名称
     */
    @Schema(description = "应用名称")
    private String appName;

    /**
     * 启用标志
     */
    @Schema(description = "启用标志")
    private Boolean enabled;

    /**
     * 备注
     */
    @Schema(description = "备注")
    private String remark;

    /**
     * 创建时间
     */
    @Schema(description = "创建时间")
    private LocalDateTime createTime;

    /**
     * 更新时间
     */
    @Schema(description = "更新时间")
    private LocalDateTime updateTime;
}
