package net.guerlab.smart.dingtalk.core.searchparams;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import net.guerlab.smart.dingtalk.core.enums.DingTalkAppType;
import net.guerlab.smart.platform.commons.searchparams.OrderSearchParams;
import net.guerlab.spring.searchparams.SearchModel;
import net.guerlab.spring.searchparams.SearchModelType;

import javax.persistence.Column;

/**
 * 钉钉应用搜索参数
 *
 * @author guer
 */
@Setter
@Getter
@ApiModel("钉钉应用搜索参数")
public class DingTalkAppSearchParams extends OrderSearchParams {

    /**
     * 应用key
     */
    @ApiModelProperty("应用key")
    private String appKey;

    /**
     * 企业ID
     */
    @ApiModelProperty("企业ID")
    private String corpId;

    /**
     * 应用类型
     */
    @ApiModelProperty("应用类型")
    private DingTalkAppType appType;

    /**
     * 应用名称关键字
     */
    @ApiModelProperty("应用名称关键字")
    @Column(name = "appName")
    @SearchModel(SearchModelType.LIKE)
    private String appNameLike;

    /**
     * 启用标志
     */
    @ApiModelProperty("启用标志")
    private Boolean enabled;
}
