package net.guerlab.smart.dingtalk.core.domain;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 钉钉用户Oauth信息
 * @author guer
 */
@Data
@ApiModel("钉钉用户Oauth信息")
public class DingTalkUserOauthInfoDTO {

    /**
     * 用户在钉钉上面的昵称
     */
    @ApiModelProperty("用户在钉钉上面的昵称")
    private String nick;

    /**
     * 用户在当前开放应用内的唯一标识
     */
    @ApiModelProperty("用户在当前开放应用内的唯一标识")
    private String openId;

    /**
     * 用户在当前开放应用所属企业的唯一标识
     */
    @ApiModelProperty("用户在当前开放应用所属企业的唯一标识")
    private String unionId;
}
