package net.guerlab.smart.dingtalk.core.domain;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import net.guerlab.smart.dingtalk.core.enums.DingTalkAppType;

import java.time.LocalDateTime;

/**
 * 钉钉应用
 *
 * @author guer
 */
@Data
@ApiModel("钉钉应用")
public class DingTalkAppDTO {

    /**
     * 应用key
     */
    @ApiModelProperty("应用key")
    private String appKey;

    /**
     * 企业ID
     */
    @ApiModelProperty("企业ID")
    private String corpId;

    /**
     * 应用密钥
     */
    @ApiModelProperty("应用密钥")
    private String appSecret;

    /**
     * 应用类型
     */
    @ApiModelProperty("应用类型")
    private DingTalkAppType appType;

    /**
     * 应用名称
     */
    @ApiModelProperty("应用名称")
    private String appName;

    /**
     * 启用标志
     */
    @ApiModelProperty("启用标志")
    private Boolean enabled;

    /**
     * 备注
     */
    @ApiModelProperty("备注")
    private String remark;

    /**
     * 创建时间
     */
    @ApiModelProperty("创建时间")
    private LocalDateTime createTime;

    /**
     * 更新时间
     */
    @ApiModelProperty("更新时间")
    private LocalDateTime updateTime;
}
