/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.dingtalk.api.feign.factory;

import net.guerlab.smart.dingtalk.api.feign.FeignDingTalkClientApi;
import net.guerlab.smart.dingtalk.core.domain.DingTalkUserDTO;
import net.guerlab.smart.dingtalk.core.domain.DingTalkUserIdInfoDTO;
import net.guerlab.smart.dingtalk.core.domain.DingTalkUserInfoDTO;
import net.guerlab.smart.dingtalk.core.domain.DingTalkUserOauthInfoDTO;
import net.guerlab.web.result.Fail;
import net.guerlab.web.result.Result;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.openfeign.FallbackFactory;

public class FeignDingTalkClientApiFallbackFactory
implements FallbackFactory<FeignDingTalkClientApi> {
    public FeignDingTalkClientApi create(Throwable cause) {
        return new FeignDingTalkClientApiFallback(cause);
    }

    static class FeignDingTalkClientApiFallback
    implements FeignDingTalkClientApi {
        private static final Logger log = LoggerFactory.getLogger(FeignDingTalkClientApiFallback.class);
        private final Throwable cause;

        @Override
        public Result<String> getAccessToken(String appKey) {
            log.error("getAccessToken fallback", this.cause);
            return new Fail("fallback");
        }

        @Override
        public Result<DingTalkUserInfoDTO> getDingTalkUserInfo(String appKey, String code) {
            log.error("getDingTalkUserInfo fallback", this.cause);
            return new Fail("fallback");
        }

        @Override
        public Result<DingTalkUserOauthInfoDTO> getDingTalkUserInfoByCode(String appKey, String code) {
            log.error("getDingTalkUserInfoByCode fallback", this.cause);
            return new Fail("fallback");
        }

        @Override
        public Result<DingTalkUserIdInfoDTO> getUserIdByUnionId(String appKey, String unionId) {
            log.error("getUserIdByUnionId fallback", this.cause);
            return new Fail("fallback");
        }

        @Override
        public Result<String> getUserIdByMobile(String appKey, String mobile) {
            log.error("getUserIdByMobile fallback", this.cause);
            return new Fail("fallback");
        }

        @Override
        public Result<DingTalkUserDTO> getUser(String appKey, String userId) {
            log.error("getUser fallback", this.cause);
            return new Fail("fallback");
        }

        public FeignDingTalkClientApiFallback(Throwable cause) {
            this.cause = cause;
        }
    }
}

