/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.dingtalk.api.feign.factory;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.guerlab.smart.dingtalk.api.feign.FeignDingTalkAppApi;
import net.guerlab.smart.dingtalk.core.domain.DingTalkAppDTO;
import net.guerlab.web.result.Fail;
import net.guerlab.web.result.ListObject;
import net.guerlab.web.result.Result;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.openfeign.FallbackFactory;

public class FeignDingTalkAppApiFallbackFactory
implements FallbackFactory<FeignDingTalkAppApi> {
    public FeignDingTalkAppApi create(Throwable cause) {
        return new FeignDingTalkAppApiFallback(cause);
    }

    static class FeignDingTalkAppApiFallback
    implements FeignDingTalkAppApi {
        private static final Logger log = LoggerFactory.getLogger(FeignDingTalkAppApiFallback.class);
        private final Throwable cause;

        @Override
        public Result<DingTalkAppDTO> findOne(String appId) {
            log.error("findOne fallback", this.cause);
            return new Fail("fallback");
        }

        @Override
        public Result<ListObject<DingTalkAppDTO>> findList(Map<String, Object> searchParams) {
            log.error("findList fallback", this.cause);
            return new Fail("fallback", (Object)ListObject.empty());
        }

        @Override
        public Result<List<DingTalkAppDTO>> findAll(Map<String, Object> searchParams) {
            log.error("findAll fallback", this.cause);
            return new Fail("fallback", Collections.emptyList());
        }

        public FeignDingTalkAppApiFallback(Throwable cause) {
            this.cause = cause;
        }
    }
}

