/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.dingtalk.api.autoconfig;

import net.guerlab.commons.exception.ApplicationException;
import net.guerlab.smart.dingtalk.api.DingTalkClientApi;
import net.guerlab.smart.dingtalk.api.autoconfig.DingTalkClientApiLocalServiceAutoConfigure;
import net.guerlab.smart.dingtalk.api.feign.FeignDingTalkClientApi;
import net.guerlab.smart.dingtalk.core.domain.DingTalkUserDTO;
import net.guerlab.smart.dingtalk.core.domain.DingTalkUserIdInfoDTO;
import net.guerlab.smart.dingtalk.core.domain.DingTalkUserInfoDTO;
import net.guerlab.smart.dingtalk.core.domain.DingTalkUserOauthInfoDTO;
import net.guerlab.web.result.Result;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@AutoConfigureAfter(value={DingTalkClientApiLocalServiceAutoConfigure.class})
public class DingTalkClientApiFeignAutoConfigure {
    @Bean
    @ConditionalOnMissingBean(value={DingTalkClientApi.class})
    public DingTalkClientApi dingTalkClientApiFeignWrapper(FeignDingTalkClientApi api) {
        return new DingTalkClientApiFeignWrapper(api);
    }

    private static class DingTalkClientApiFeignWrapper
    implements DingTalkClientApi {
        private final FeignDingTalkClientApi api;

        @Override
        public String getAccessToken(String appKey) {
            Result<String> result = this.api.getAccessToken(appKey);
            if (result.isStatus()) {
                return (String)result.getData();
            }
            throw new ApplicationException(result.getMessage(), result.getErrorCode());
        }

        @Override
        public DingTalkUserInfoDTO getDingTalkUserInfo(String appKey, String code) {
            Result<DingTalkUserInfoDTO> result = this.api.getDingTalkUserInfo(appKey, code);
            if (result.isStatus()) {
                return (DingTalkUserInfoDTO)result.getData();
            }
            throw new ApplicationException(result.getMessage(), result.getErrorCode());
        }

        @Override
        public DingTalkUserOauthInfoDTO getDingTalkUserInfoByCode(String appKey, String code) {
            Result<DingTalkUserOauthInfoDTO> result = this.api.getDingTalkUserInfoByCode(appKey, code);
            if (result.isStatus()) {
                return (DingTalkUserOauthInfoDTO)result.getData();
            }
            throw new ApplicationException(result.getMessage(), result.getErrorCode());
        }

        @Override
        public DingTalkUserIdInfoDTO getUserIdByUnionId(String appKey, String unionId) {
            Result<DingTalkUserIdInfoDTO> result = this.api.getUserIdByUnionId(appKey, unionId);
            if (result.isStatus()) {
                return (DingTalkUserIdInfoDTO)result.getData();
            }
            throw new ApplicationException(result.getMessage(), result.getErrorCode());
        }

        @Override
        public String getUserIdByMobile(String appKey, String mobile) {
            Result<String> result = this.api.getUserIdByMobile(appKey, mobile);
            if (result.isStatus()) {
                return (String)result.getData();
            }
            throw new ApplicationException(result.getMessage(), result.getErrorCode());
        }

        @Override
        public DingTalkUserDTO getUser(String appKey, String userId) {
            Result<DingTalkUserDTO> result = this.api.getUser(appKey, userId);
            if (result.isStatus()) {
                return (DingTalkUserDTO)result.getData();
            }
            throw new ApplicationException(result.getMessage(), result.getErrorCode());
        }

        public DingTalkClientApiFeignWrapper(FeignDingTalkClientApi api) {
            this.api = api;
        }
    }
}

