/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.dingtalk.api.autoconfig;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import net.guerlab.smart.dingtalk.api.DingTalkAppApi;
import net.guerlab.smart.dingtalk.core.domain.DingTalkAppDTO;
import net.guerlab.smart.dingtalk.core.exception.DingTalkAppInvalidException;
import net.guerlab.smart.dingtalk.core.searchparams.DingTalkAppSearchParams;
import net.guerlab.smart.dingtalk.service.entity.DingTalkApp;
import net.guerlab.smart.dingtalk.service.service.DingTalkAppService;
import net.guerlab.smart.platform.commons.util.BeanConvertUtils;
import net.guerlab.spring.searchparams.AbstractSearchParams;
import net.guerlab.web.result.ListObject;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.lang.NonNull;

@Configuration
@Conditional(value={WrapperCondition.class})
public class DingTalkAppApiLocalServiceAutoConfigure {
    @Bean
    @ConditionalOnBean(value={DingTalkAppService.class})
    public DingTalkAppApi dingTalkAppApiLocalServiceWrapper(DingTalkAppService service) {
        return new DingTalkAppApiLocalServiceWrapper(service);
    }

    private static class DingTalkAppApiLocalServiceWrapper
    implements DingTalkAppApi {
        private final DingTalkAppService service;

        @Override
        public DingTalkAppDTO findOne(String appId) {
            return (DingTalkAppDTO)((DingTalkApp)this.service.selectByIdOptional((Serializable)((Object)appId)).orElseThrow(DingTalkAppInvalidException::new)).convert();
        }

        @Override
        public ListObject<DingTalkAppDTO> findList(DingTalkAppSearchParams searchParams) {
            return BeanConvertUtils.toListObject((ListObject)this.service.selectPage((AbstractSearchParams)searchParams));
        }

        @Override
        public List<DingTalkAppDTO> findAll(DingTalkAppSearchParams searchParams) {
            return BeanConvertUtils.toList((Collection)this.service.selectAll((AbstractSearchParams)searchParams));
        }

        public DingTalkAppApiLocalServiceWrapper(DingTalkAppService service) {
            this.service = service;
        }
    }

    static class WrapperCondition
    implements Condition {
        WrapperCondition() {
        }

        public boolean matches(@NonNull ConditionContext context, @NonNull AnnotatedTypeMetadata metadata) {
            try {
                return WrapperCondition.class.getClassLoader().loadClass("net.guerlab.smart.dingtalk.service.service.DingTalkAppService") != null;
            }
            catch (Exception e) {
                return false;
            }
        }
    }
}

