/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.dingtalk.api.autoconfig;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import net.guerlab.smart.dingtalk.api.DingTalkAppApi;
import net.guerlab.smart.dingtalk.api.autoconfig.DingTalkAppApiLocalServiceAutoConfigure;
import net.guerlab.smart.dingtalk.api.feign.FeignDingTalkAppApi;
import net.guerlab.smart.dingtalk.core.domain.DingTalkAppDTO;
import net.guerlab.smart.dingtalk.core.exception.DingTalkAppInvalidException;
import net.guerlab.smart.dingtalk.core.searchparams.DingTalkAppSearchParams;
import net.guerlab.spring.searchparams.AbstractSearchParams;
import net.guerlab.spring.searchparams.SearchParamsUtils;
import net.guerlab.web.result.ListObject;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@AutoConfigureAfter(value={DingTalkAppApiLocalServiceAutoConfigure.class})
public class DingTalkAppApiFeignAutoConfigure {
    @Bean
    @ConditionalOnMissingBean(value={DingTalkAppApi.class})
    public DingTalkAppApi dingTalkAppApiFeignWrapper(FeignDingTalkAppApi api) {
        return new DingTalkAppApiFeignWrapper(api);
    }

    private static class DingTalkAppApiFeignWrapper
    implements DingTalkAppApi {
        private final FeignDingTalkAppApi api;

        @Override
        public DingTalkAppDTO findOne(String appId) {
            return Optional.ofNullable((DingTalkAppDTO)this.api.findOne(appId).getData()).orElseThrow(DingTalkAppInvalidException::new);
        }

        @Override
        public ListObject<DingTalkAppDTO> findList(DingTalkAppSearchParams searchParams) {
            HashMap<String, Object> params = new HashMap<String, Object>(8);
            SearchParamsUtils.handler((AbstractSearchParams)searchParams, params);
            return Optional.ofNullable((ListObject)this.api.findList(params).getData()).orElse(ListObject.empty());
        }

        @Override
        public List<DingTalkAppDTO> findAll(DingTalkAppSearchParams searchParams) {
            HashMap<String, Object> params = new HashMap<String, Object>(8);
            SearchParamsUtils.handler((AbstractSearchParams)searchParams, params);
            return Optional.ofNullable((List)this.api.findAll(params).getData()).orElse(Collections.emptyList());
        }

        public DingTalkAppApiFeignWrapper(FeignDingTalkAppApi api) {
            this.api = api;
        }
    }
}

