/*
 * Copyright 2018-2021 guerlab.net and other contributors.
 *
 * Licensed under the GNU LESSER GENERAL PUBLIC LICENSE, Version 3 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.guerlab.smart.dingtalk.api.feign.factory;

import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import net.guerlab.smart.dingtalk.api.feign.FeignDingTalkClientApi;
import net.guerlab.smart.dingtalk.core.domain.DingTalkUserDTO;
import net.guerlab.smart.dingtalk.core.domain.DingTalkUserIdInfoDTO;
import net.guerlab.smart.dingtalk.core.domain.DingTalkUserInfoDTO;
import net.guerlab.smart.dingtalk.core.domain.DingTalkUserOauthInfoDTO;
import net.guerlab.web.result.Fail;
import net.guerlab.web.result.Result;
import org.springframework.cloud.openfeign.FallbackFactory;

/**
 * 钉钉应用快速失败类构建工厂
 *
 * @author guer
 */
public class FeignDingTalkClientApiFallbackFactory implements FallbackFactory<FeignDingTalkClientApi> {

    @Override
    public FeignDingTalkClientApi create(Throwable cause) {
        return new FeignDingTalkClientApiFallback(cause);
    }

    /**
     * 钉钉应用快速失败实现
     */
    @Slf4j
    @AllArgsConstructor
    static class FeignDingTalkClientApiFallback implements FeignDingTalkClientApi {

        private final Throwable cause;

        @Override
        public Result<String> getAccessToken(String appKey) {
            log.error("getAccessToken fallback", cause);
            return new Fail<>("fallback");
        }

        @Override
        public Result<DingTalkUserInfoDTO> getDingTalkUserInfo(String appKey, String code) {
            log.error("getDingTalkUserInfo fallback", cause);
            return new Fail<>("fallback");
        }

        @Override
        public Result<DingTalkUserOauthInfoDTO> getDingTalkUserInfoByCode(String appKey, String code) {
            log.error("getDingTalkUserInfoByCode fallback", cause);
            return new Fail<>("fallback");
        }

        @Override
        public Result<DingTalkUserIdInfoDTO> getUserIdByUnionId(String appKey, String unionId) {
            log.error("getUserIdByUnionId fallback", cause);
            return new Fail<>("fallback");
        }

        @Override
        public Result<String> getUserIdByMobile(String appKey, String mobile) {
            log.error("getUserIdByMobile fallback", cause);
            return new Fail<>("fallback");
        }

        @Override
        public Result<DingTalkUserDTO> getUser(String appKey, String userId) {
            log.error("getUser fallback", cause);
            return new Fail<>("fallback");
        }
    }
}
