/*
 * Copyright 2018-2021 guerlab.net and other contributors.
 *
 * Licensed under the GNU LESSER GENERAL PUBLIC LICENSE, Version 3 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.guerlab.smart.dingtalk.api.feign.factory;

import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import net.guerlab.smart.dingtalk.api.feign.FeignDingTalkAppApi;
import net.guerlab.smart.dingtalk.core.domain.DingTalkAppDTO;
import net.guerlab.web.result.Fail;
import net.guerlab.web.result.ListObject;
import net.guerlab.web.result.Result;
import org.springframework.cloud.openfeign.FallbackFactory;

import java.util.Collections;
import java.util.List;
import java.util.Map;

/**
 * 钉钉应用服务快速失败类构建工厂
 *
 * @author guer
 */
public class FeignDingTalkAppApiFallbackFactory implements FallbackFactory<FeignDingTalkAppApi> {

    @Override
    public FeignDingTalkAppApi create(Throwable cause) {
        return new FeignDingTalkAppApiFallback(cause);
    }

    /**
     * 钉钉应用服务快速失败实现
     */
    @Slf4j
    @AllArgsConstructor
    static class FeignDingTalkAppApiFallback implements FeignDingTalkAppApi {

        private final Throwable cause;

        @Override
        public Result<DingTalkAppDTO> findOne(String appId) {
            log.error("findOne fallback", cause);
            return new Fail<>("fallback");
        }

        @Override
        public Result<ListObject<DingTalkAppDTO>> findList(Map<String, Object> searchParams) {
            log.error("findList fallback", cause);
            return new Fail<>("fallback", ListObject.empty());
        }

        @Override
        public Result<List<DingTalkAppDTO>> findAll(Map<String, Object> searchParams) {
            log.error("findAll fallback", cause);
            return new Fail<>("fallback", Collections.emptyList());
        }
    }
}
