/*
 * Copyright 2018-2021 guerlab.net and other contributors.
 *
 * Licensed under the GNU LESSER GENERAL PUBLIC LICENSE, Version 3 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.guerlab.smart.dingtalk.api.feign;

import net.guerlab.smart.dingtalk.api.feign.factory.FeignDingTalkClientApiFallbackFactory;
import net.guerlab.smart.dingtalk.core.domain.DingTalkUserDTO;
import net.guerlab.smart.dingtalk.core.domain.DingTalkUserIdInfoDTO;
import net.guerlab.smart.dingtalk.core.domain.DingTalkUserInfoDTO;
import net.guerlab.smart.dingtalk.core.domain.DingTalkUserOauthInfoDTO;
import net.guerlab.web.result.Result;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;

/**
 * 钉钉应用接口
 *
 * @author guer
 */
@FeignClient(name = "dingtalk-internal/inside/dingTalkClient", fallbackFactory = FeignDingTalkClientApiFallbackFactory.class)
public interface FeignDingTalkClientApi {

    /**
     * 根据钉钉应用id查询钉钉应用accessToken
     *
     * @param appKey
     *         appKey
     * @return accessToken
     */
    @GetMapping("/{appKey}/accessToken")
    Result<String> getAccessToken(@PathVariable("appKey") String appKey);

    /**
     * 通过code获取用户信息
     *
     * @param appKey
     *         appKey
     * @param code
     *         code
     * @return 用户信息
     */
    @GetMapping("/{appKey}/user/getUserInfo/{code}")
    Result<DingTalkUserInfoDTO> getDingTalkUserInfo(@PathVariable("appKey") String appKey, @PathVariable("code") String code);

    /**
     * 通过code获取用户Oauth信息
     *
     * @param appKey
     *         appKey
     * @param code
     *         code
     * @return 用户Oauth信息
     */
    @GetMapping("/{appKey}/user/getUserInfoBycode/{code}")
    Result<DingTalkUserOauthInfoDTO> getDingTalkUserInfoByCode(@PathVariable("appKey") String appKey, @PathVariable("code") String code);

    /**
     * 通过unionId获取用户id信息
     *
     * @param appKey
     *         appKey
     * @param unionId
     *         unionId
     * @return 用户id信息
     */
    @GetMapping("/{appKey}/user/getUserIdByUnionId/{unionId}")
    Result<DingTalkUserIdInfoDTO> getUserIdByUnionId(@PathVariable("appKey") String appKey, @PathVariable("unionId") String unionId);

    /**
     * 通过电话号码获取用户id
     *
     * @param appKey
     *         appKey
     * @param mobile
     *         电话号码
     * @return 用户id
     */
    @GetMapping("/{appKey}/user/getUserIdByMobile/{mobile}")
    Result<String> getUserIdByMobile(@PathVariable("appKey") String appKey, @PathVariable("mobile") String mobile);

    /**
     * 获取用户
     *
     * @param appKey
     *         appKey
     * @param userId
     *         用户ID
     * @return 用户信息
     */
    @GetMapping("/{appKey}/user/getUser/{userId}")
    Result<DingTalkUserDTO> getUser(@PathVariable("appKey") String appKey, @PathVariable("userId") String userId);
}
