/*
 * Copyright 2018-2021 guerlab.net and other contributors.
 *
 * Licensed under the GNU LESSER GENERAL PUBLIC LICENSE, Version 3 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.guerlab.smart.dingtalk.api.feign;

import net.guerlab.smart.dingtalk.api.feign.factory.FeignDingTalkAppApiFallbackFactory;
import net.guerlab.smart.dingtalk.core.domain.DingTalkAppDTO;
import net.guerlab.web.result.ListObject;
import net.guerlab.web.result.Result;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;
import java.util.Map;

/**
 * 钉钉应用服务接口
 *
 * @author guer
 */
@FeignClient(name = "dingtalk-internal/inside/wxApp", fallbackFactory = FeignDingTalkAppApiFallbackFactory.class)
public interface FeignDingTalkAppApi {

    /**
     * 根据钉钉应用id查询钉钉应用
     *
     * @param appKey
     *         appKey
     * @return 钉钉应用
     */
    @GetMapping("/{appKey}")
    Result<DingTalkAppDTO> findOne(@PathVariable("appKey") String appKey);

    /**
     * 根据搜索参数查询钉钉应用列表
     *
     * @param searchParams
     *         搜索参数
     * @return 钉钉应用列表
     */
    @PostMapping
    Result<ListObject<DingTalkAppDTO>> findList(@RequestBody Map<String, Object> searchParams);

    /**
     * 根据搜索参数查询钉钉应用列表
     *
     * @param searchParams
     *         搜索参数
     * @return 钉钉应用列表
     */
    @PostMapping("/all")
    Result<List<DingTalkAppDTO>> findAll(@RequestBody Map<String, Object> searchParams);
}
