/*
 * Copyright 2018-2021 guerlab.net and other contributors.
 *
 * Licensed under the GNU LESSER GENERAL PUBLIC LICENSE, Version 3 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.guerlab.smart.dingtalk.api;

import net.guerlab.smart.dingtalk.core.domain.DingTalkAppDTO;
import net.guerlab.smart.dingtalk.core.searchparams.DingTalkAppSearchParams;
import net.guerlab.web.result.ListObject;

import java.util.List;

/**
 * 钉钉应用服务接口
 *
 * @author guer
 */
public interface DingTalkAppApi {

    /**
     * 根据appKey查询钉钉应用
     *
     * @param appKey
     *         appKey
     * @return 钉钉应用
     */
    DingTalkAppDTO findOne(String appKey);

    /**
     * 根据搜索参数查询钉钉应用列表
     *
     * @param searchParams
     *         搜索参数
     * @return 钉钉应用列表
     */
    ListObject<DingTalkAppDTO> findList(DingTalkAppSearchParams searchParams);

    /**
     * 根据搜索参数查询钉钉应用列表
     *
     * @param searchParams
     *         搜索参数
     * @return 钉钉应用列表
     */
    List<DingTalkAppDTO> findAll(DingTalkAppSearchParams searchParams);
}
