/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.dingtalk.api.autoconfig;

import net.guerlab.commons.exception.ApplicationException;
import net.guerlab.sdk.dingtalk.client.DingTalkClient;
import net.guerlab.sdk.dingtalk.request.AbstractDingTalkRequest;
import net.guerlab.sdk.dingtalk.request.AbstractSnsRequest;
import net.guerlab.sdk.dingtalk.request.sns.GetUserInfoByCodeRequest;
import net.guerlab.sdk.dingtalk.request.user.GetUserIdByMobileRequest;
import net.guerlab.sdk.dingtalk.request.user.GetUserIdByUnionIdRequest;
import net.guerlab.sdk.dingtalk.request.user.UserGetUserInfoRequest;
import net.guerlab.sdk.dingtalk.response.sns.GetUserInfoByCodeResponse;
import net.guerlab.sdk.dingtalk.response.user.GetUserIdByMobileResponse;
import net.guerlab.sdk.dingtalk.response.user.GetUserIdByUnionIdResponse;
import net.guerlab.sdk.dingtalk.response.user.UserGetUserInfoResponse;
import net.guerlab.smart.dingtalk.api.DingTalkClientApi;
import net.guerlab.smart.dingtalk.core.domain.DingTalkUserIdInfoDTO;
import net.guerlab.smart.dingtalk.core.domain.DingTalkUserInfoDTO;
import net.guerlab.smart.dingtalk.core.domain.DingTalkUserOauthInfoDTO;
import net.guerlab.smart.dingtalk.service.service.DingTalkClientManagerService;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.lang.NonNull;

@Configuration
@Conditional(value={WrapperCondition.class})
public class DingTalkClientApiLocalServiceAutoConfigure {
    @Bean
    @ConditionalOnBean(value={DingTalkClientManagerService.class})
    public DingTalkClientApi dingTalkClientApiLocalServiceWrapper(DingTalkClientManagerService managerService) {
        return new DingTalkClientApiLocalServiceWrapper(managerService);
    }

    private static class DingTalkClientApiLocalServiceWrapper
    implements DingTalkClientApi {
        private final DingTalkClientManagerService managerService;

        @Override
        public String getAccessToken(String appKey) {
            return this.getClient(appKey).getAccessToken();
        }

        @Override
        public DingTalkUserInfoDTO getDingTalkUserInfo(String appKey, String code) {
            UserGetUserInfoRequest request = new UserGetUserInfoRequest();
            request.setCode(code);
            UserGetUserInfoResponse response = (UserGetUserInfoResponse)this.getClient(appKey).execute((AbstractDingTalkRequest)request);
            if (response.getErrcode() > 0) {
                throw new ApplicationException(response.getErrmsg(), response.getErrcode());
            }
            DingTalkUserInfoDTO result = new DingTalkUserInfoDTO();
            result.setIsSys(Boolean.valueOf(response.isSys()));
            result.setSysLevel(Integer.valueOf(response.getSysLevel()));
            result.setUserId(response.getUserId());
            return result;
        }

        @Override
        public DingTalkUserOauthInfoDTO getDingTalkUserInfoByCode(String appKey, String code) {
            GetUserInfoByCodeRequest request = new GetUserInfoByCodeRequest();
            request.setTmpAuthCode(code);
            GetUserInfoByCodeResponse response = (GetUserInfoByCodeResponse)this.getClient(appKey).execute((AbstractSnsRequest)request);
            if (response.getErrcode() > 0) {
                throw new ApplicationException(response.getErrmsg(), response.getErrcode());
            }
            GetUserInfoByCodeResponse.UserInfo userInfo = response.getUserInfo();
            DingTalkUserOauthInfoDTO result = new DingTalkUserOauthInfoDTO();
            result.setNick(userInfo.getNick());
            result.setOpenId(userInfo.getOpenId());
            result.setUnionId(userInfo.getUnionId());
            return result;
        }

        @Override
        public DingTalkUserIdInfoDTO getUserIdByUnionId(String appKey, String unionId) {
            GetUserIdByUnionIdRequest request = new GetUserIdByUnionIdRequest();
            request.setUnionId(unionId);
            GetUserIdByUnionIdResponse response = (GetUserIdByUnionIdResponse)this.getClient(appKey).execute((AbstractDingTalkRequest)request);
            if (response.getErrcode() > 0) {
                throw new ApplicationException(response.getErrmsg(), response.getErrcode());
            }
            DingTalkUserIdInfoDTO result = new DingTalkUserIdInfoDTO();
            result.setUserId(response.getUserId());
            result.setContactType(Integer.valueOf(response.getContactType()));
            return result;
        }

        @Override
        public String getUserIdByMobile(String appKey, String mobile) {
            GetUserIdByMobileRequest request = new GetUserIdByMobileRequest();
            request.setMobile(mobile);
            GetUserIdByMobileResponse response = (GetUserIdByMobileResponse)this.getClient(appKey).execute((AbstractDingTalkRequest)request);
            if (response.getErrcode() > 0) {
                throw new ApplicationException(response.getErrmsg(), response.getErrcode());
            }
            return response.getUserId();
        }

        private DingTalkClient getClient(String appKey) {
            return this.managerService.getClient(appKey);
        }

        public DingTalkClientApiLocalServiceWrapper(DingTalkClientManagerService managerService) {
            this.managerService = managerService;
        }
    }

    static class WrapperCondition
    implements Condition {
        WrapperCondition() {
        }

        public boolean matches(@NonNull ConditionContext context, @NonNull AnnotatedTypeMetadata metadata) {
            try {
                return WrapperCondition.class.getClassLoader().loadClass("net.guerlab.smart.dingtalk.service.service.DingTalkClientManagerService") != null;
            }
            catch (Exception e) {
                return false;
            }
        }
    }
}

