package net.guerlab.smart.dingtalk.api.feign.factory;

import feign.hystrix.FallbackFactory;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import net.guerlab.smart.dingtalk.api.feign.FeignDingTalkClientApi;
import net.guerlab.smart.dingtalk.core.domain.DingTalkUserIdInfoDTO;
import net.guerlab.smart.dingtalk.core.domain.DingTalkUserInfoDTO;
import net.guerlab.smart.dingtalk.core.domain.DingTalkUserOauthInfoDTO;
import net.guerlab.web.result.Fail;
import net.guerlab.web.result.Result;

/**
 * 钉钉应用快速失败类构建工厂
 *
 * @author guer
 */
public class FeignDingTalkClientApiFallbackFactory implements FallbackFactory<FeignDingTalkClientApi> {

    @Override
    public FeignDingTalkClientApi create(Throwable cause) {
        return new FeignDingTalkClientApiFallback(cause);
    }

    /**
     * 钉钉应用快速失败实现
     */
    @Slf4j
    @AllArgsConstructor
    static class FeignDingTalkClientApiFallback implements FeignDingTalkClientApi {

        private final Throwable cause;

        @Override
        public Result<String> getAccessToken(String appKey) {
            log.error("getAccessToken fallback", cause);
            return new Fail<>("fallback");
        }

        @Override
        public Result<DingTalkUserInfoDTO> getDingTalkUserInfo(String appKey, String code) {
            log.error("getDingTalkUserInfo fallback", cause);
            return new Fail<>("fallback");
        }

        @Override
        public Result<DingTalkUserOauthInfoDTO> getDingTalkUserInfoByCode(String appKey, String code) {
            log.error("getDingTalkUserInfoByCode fallback", cause);
            return new Fail<>("fallback");
        }

        @Override
        public Result<DingTalkUserIdInfoDTO> getUserIdByUnionId(String appKey, String unionId) {
            log.error("getUserIdByUnionId fallback", cause);
            return new Fail<>("fallback");
        }

        @Override
        public Result<String> getUserIdByMobile(String appKey, String mobile) {
            log.error("getUserIdByMobile fallback", cause);
            return new Fail<>("fallback");
        }
    }
}
