package net.guerlab.smart.dingtalk.api.autoconfig;

import lombok.AllArgsConstructor;
import net.guerlab.smart.dingtalk.api.DingTalkAppApi;
import net.guerlab.smart.dingtalk.core.domain.DingTalkAppDTO;
import net.guerlab.smart.dingtalk.core.exception.DingTalkAppInvalidException;
import net.guerlab.smart.dingtalk.core.searchparams.DingTalkAppSearchParams;
import net.guerlab.smart.dingtalk.service.service.DingTalkAppService;
import net.guerlab.smart.platform.commons.util.BeanConvertUtils;
import net.guerlab.web.result.ListObject;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.context.annotation.*;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.lang.NonNull;

import java.util.List;

/**
 * @author guer
 */
@Configuration
@Conditional(DingTalkAppApiLocalServiceAutoConfigure.WrapperCondition.class)
public class DingTalkAppApiLocalServiceAutoConfigure {

    @SuppressWarnings("SpringJavaInjectionPointsAutowiringInspection")
    @Bean
    @ConditionalOnBean(DingTalkAppService.class)
    public DingTalkAppApi dingTalkAppApiLocalServiceWrapper(DingTalkAppService service) {
        return new DingTalkAppApiLocalServiceWrapper(service);
    }

    @SuppressWarnings("WeakerAccess")
    static class WrapperCondition implements Condition {

        @Override
        public boolean matches(@NonNull ConditionContext context, @NonNull AnnotatedTypeMetadata metadata) {
            try {
                return WrapperCondition.class.getClassLoader()
                        .loadClass("net.guerlab.smart.dingtalk.service.service.DingTalkAppService") != null;
            } catch (Exception e) {
                return false;
            }
        }
    }

    @AllArgsConstructor
    private static class DingTalkAppApiLocalServiceWrapper implements DingTalkAppApi {

        private final DingTalkAppService service;

        @Override
        public DingTalkAppDTO findOne(String appId) {
            return service.selectByIdOptional(appId).orElseThrow(DingTalkAppInvalidException::new).toDTO();
        }

        @Override
        public ListObject<DingTalkAppDTO> findList(DingTalkAppSearchParams searchParams) {
            return BeanConvertUtils.toListObject(service.selectPage(searchParams));
        }

        @Override
        public List<DingTalkAppDTO> findAll(DingTalkAppSearchParams searchParams) {
            return BeanConvertUtils.toList(service.selectAll(searchParams));
        }
    }

}
