package net.guerlab.smart.dingtalk.api.autoconfig;

import lombok.AllArgsConstructor;
import net.guerlab.smart.dingtalk.api.DingTalkAppApi;
import net.guerlab.smart.dingtalk.api.feign.FeignDingTalkAppApi;
import net.guerlab.smart.dingtalk.core.domain.DingTalkAppDTO;
import net.guerlab.smart.dingtalk.core.exception.DingTalkAppInvalidException;
import net.guerlab.smart.dingtalk.core.searchparams.DingTalkAppSearchParams;
import net.guerlab.spring.searchparams.SearchParamsUtils;
import net.guerlab.web.result.ListObject;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import java.util.*;

/**
 * @author guer
 */
@Configuration
@AutoConfigureAfter(DingTalkAppApiLocalServiceAutoConfigure.class)
public class DingTalkAppApiFeignAutoConfigure {

    @SuppressWarnings("SpringJavaInjectionPointsAutowiringInspection")
    @Bean
    @ConditionalOnMissingBean(DingTalkAppApi.class)
    public DingTalkAppApi dingTalkAppApiFeignWrapper(FeignDingTalkAppApi api) {
        return new DingTalkAppApiFeignWrapper(api);
    }

    @AllArgsConstructor
    private static class DingTalkAppApiFeignWrapper implements DingTalkAppApi {

        private final FeignDingTalkAppApi api;

        @Override
        public DingTalkAppDTO findOne(String appId) {
            return Optional.ofNullable(api.findOne(appId).getData()).orElseThrow(DingTalkAppInvalidException::new);
        }

        @Override
        public ListObject<DingTalkAppDTO> findList(DingTalkAppSearchParams searchParams) {
            Map<String, Object> params = new HashMap<>(8);
            SearchParamsUtils.handler(searchParams, params);
            return Optional.ofNullable(api.findList(params).getData()).orElse(ListObject.empty());
        }

        @Override
        public List<DingTalkAppDTO> findAll(DingTalkAppSearchParams searchParams) {
            Map<String, Object> params = new HashMap<>(8);
            SearchParamsUtils.handler(searchParams, params);
            return Optional.ofNullable(api.findAll(params).getData()).orElse(Collections.emptyList());
        }
    }

}
