package net.guerlab.smart.dingtalk.api;

import net.guerlab.smart.dingtalk.core.domain.DingTalkUserIdInfoDTO;
import net.guerlab.smart.dingtalk.core.domain.DingTalkUserInfoDTO;
import net.guerlab.smart.dingtalk.core.domain.DingTalkUserOauthInfoDTO;

/**
 * 钉钉应用接口
 *
 * @author guer
 */
public interface DingTalkClientApi {

    /**
     * 根据appKey查询钉钉应用
     *
     * @param appKey
     *         appKey
     * @return access token
     */
    String getAccessToken(String appKey);

    /**
     * 通过code获取用户信息
     *
     * @param appKey
     *         appKey
     * @param code
     *         code
     * @return 用户信息
     */
    DingTalkUserInfoDTO getDingTalkUserInfo(String appKey, String code);

    /**
     * 通过code获取用户Oauth信息
     *
     * @param appKey
     *         appKey
     * @param code
     *         code
     * @return 用户Oauth信息
     */
    DingTalkUserOauthInfoDTO getDingTalkUserInfoByCode(String appKey, String code);

    /**
     * 通过unionId获取用户id信息
     *
     * @param appKey
     *         appKey
     * @param unionId
     *         unionId
     * @return 用户id信息
     */
    DingTalkUserIdInfoDTO getUserIdByUnionId(String appKey, String unionId);

    /**
     * 通过电话号码获取用户id
     *
     * @param appKey
     *         appKey
     * @param mobile
     *         电话号码
     * @return 用户id
     */
    String getUserIdByMobile(String appKey, String mobile);
}
