package net.guerlab.smart.dingtalk.api;

import net.guerlab.smart.dingtalk.core.domain.DingTalkAppDTO;
import net.guerlab.smart.dingtalk.core.searchparams.DingTalkAppSearchParams;
import net.guerlab.web.result.ListObject;

import java.util.List;

/**
 * 钉钉应用服务接口
 *
 * @author guer
 */
public interface DingTalkAppApi {

    /**
     * 根据appKey查询钉钉应用
     *
     * @param appKey
     *         appKey
     * @return 钉钉应用
     */
    DingTalkAppDTO findOne(String appKey);

    /**
     * 根据搜索参数查询钉钉应用列表
     *
     * @param searchParams
     *         搜索参数
     * @return 钉钉应用列表
     */
    ListObject<DingTalkAppDTO> findList(DingTalkAppSearchParams searchParams);

    /**
     * 根据搜索参数查询钉钉应用列表
     *
     * @param searchParams
     *         搜索参数
     * @return 钉钉应用列表
     */
    List<DingTalkAppDTO> findAll(DingTalkAppSearchParams searchParams);
}
