package net.guerlab.smart.article.web.controller.user;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import net.guerlab.smart.article.service.service.ArticleConfigService;
import net.guerlab.smart.user.api.OperationLogApi;
import net.guerlab.smart.user.auth.UserContextHandler;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.Collection;
import java.util.Map;

/**
 * 文章配置
 *
 * @author guer
 */
@Api(tags = "文章配置")
@RestController("/user/articleConfig")
@RequestMapping("/user/articleConfig")
public class ArticleConfigController {

    private ArticleConfigService configService;

    private OperationLogApi operationLogApi;

    @ApiOperation("查询配置")
    @PostMapping
    public Map<String, String> findMap(@RequestBody(required = false) Collection<String> keys) {
        if (keys == null || keys.isEmpty()) {
            return configService.findAll();
        } else {
            return configService.findMap(keys);
        }
    }

    @ApiOperation("保存配置")
    @PostMapping("/save")
    public Map<String, String> save(@RequestBody Map<String, String> configs) {
        configService.save(configs);
        Map<String, String> result = configService.findMap(configs.keySet());
        operationLogApi.add("保存文章配置", UserContextHandler.getUserId(), configs);
        return result;
    }

    @Autowired
    public void setConfigService(ArticleConfigService configService) {
        this.configService = configService;
    }

    @SuppressWarnings("SpringJavaInjectionPointsAutowiringInspection")
    @Autowired
    public void setOperationLogApi(OperationLogApi operationLogApi) {
        this.operationLogApi = operationLogApi;
    }

}
