package net.guerlab.smart.article.web.controller.user;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import net.guerlab.commons.exception.ApplicationException;
import net.guerlab.smart.article.core.domain.ArticleCategoryDTO;
import net.guerlab.smart.article.core.exception.ArticleCategoryInvalidException;
import net.guerlab.smart.article.core.searchparams.ArticleCategorySearchParams;
import net.guerlab.smart.article.service.entity.ArticleCategory;
import net.guerlab.smart.article.service.service.ArticleCategoryService;
import net.guerlab.smart.platform.commons.util.BeanConvertUtils;
import net.guerlab.smart.platform.commons.util.TreeUtils;
import net.guerlab.smart.platform.server.controller.BaseController;
import net.guerlab.smart.user.api.OperationLogApi;
import net.guerlab.smart.user.auth.UserContextHandler;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.Collection;

/**
 * 文章分类
 *
 * @author guer
 */
@Api(tags = "文章分类")
@RestController("/user/articleCategory")
@RequestMapping("/user/articleCategory")
public class ArticleCategoryController
        extends BaseController<ArticleCategoryDTO, ArticleCategory, ArticleCategoryService, ArticleCategorySearchParams, Long> {

    private OperationLogApi operationLogApi;

    @Override
    public void copyProperties(ArticleCategoryDTO dto, ArticleCategory entity, Long id) {
        super.copyProperties(dto, entity, id);
        entity.setArticleCategoryId(id);
    }

    @Override
    protected ApplicationException nullPointException() {
        return new ArticleCategoryInvalidException();
    }

    @ApiOperation("获取树状结构")
    @GetMapping("/tree")
    public Collection<ArticleCategoryDTO> tree() {
        return TreeUtils.tree(BeanConvertUtils.toList(getService().selectAll()));
    }

    @Override
    public void afterSave(ArticleCategory entity, ArticleCategoryDTO dto) {
        operationLogApi.add("添加文章分类", UserContextHandler.getUserId(), entity);
    }

    @Override
    public void afterUpdate(ArticleCategory entity, ArticleCategoryDTO dto) {
        operationLogApi.add("编辑文章分类", UserContextHandler.getUserId(), entity);
    }

    @Override
    public void afterDelete(ArticleCategory entity) {
        operationLogApi.add("删除文章分类", UserContextHandler.getUserId(), entity.getArticleCategoryId());
    }

    @SuppressWarnings("SpringJavaInjectionPointsAutowiringInspection")
    @Autowired
    public void setOperationLogApi(OperationLogApi operationLogApi) {
        this.operationLogApi = operationLogApi;
    }
}
