package net.guerlab.smart.article.web.controller.commons;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import net.guerlab.commons.exception.ApplicationException;
import net.guerlab.smart.article.core.domain.ArticleCategoryDTO;
import net.guerlab.smart.article.core.exception.ArticleCategoryInvalidException;
import net.guerlab.smart.article.core.searchparams.ArticleCategorySearchParams;
import net.guerlab.smart.article.service.entity.ArticleCategory;
import net.guerlab.smart.article.service.service.ArticleCategoryService;
import net.guerlab.smart.platform.commons.util.BeanConvertUtils;
import net.guerlab.smart.platform.commons.util.TreeUtils;
import net.guerlab.smart.platform.server.controller.BaseFindController;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.Collection;

/**
 * 文章分类
 *
 * @author guer
 */
@Api(tags = "文章分类")
@RestController("/commons/articleCategory")
@RequestMapping("/commons/articleCategory")
public class ArticleCategoryController
        extends BaseFindController<ArticleCategoryDTO, ArticleCategory, ArticleCategoryService, ArticleCategorySearchParams, Long> {

    @ApiOperation("获取树状结构")
    @GetMapping("/tree")
    public Collection<ArticleCategoryDTO> tree() {
        ArticleCategorySearchParams searchParams = new ArticleCategorySearchParams();
        searchParams.setEnabled(true);
        return TreeUtils.tree(BeanConvertUtils.toList(getService().selectAll(searchParams)));
    }

    @Override
    public ArticleCategory findOne0(Long id) {
        ArticleCategory articleCategory = super.findOne0(id);

        if (!articleCategory.getEnabled()) {
            throw new ArticleCategoryInvalidException();
        }

        return articleCategory;
    }

    @Override
    protected ApplicationException nullPointException() {
        return new ArticleCategoryInvalidException();
    }

    @Override
    public void beforeFind(ArticleCategorySearchParams searchParams) {
        searchParams.setEnabled(true);
    }
}
