/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.article.web.controller.user;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.guerlab.commons.collection.CollectionUtil;
import net.guerlab.smart.article.core.domain.ArticleDTO;
import net.guerlab.smart.article.core.enums.AuditStatus;
import net.guerlab.smart.article.core.enums.PublishType;
import net.guerlab.smart.article.core.exception.ArticleAuditStatusErrorException;
import net.guerlab.smart.article.core.exception.ArticleInvalidException;
import net.guerlab.smart.article.core.searchparams.ArticleCategorySearchParams;
import net.guerlab.smart.article.service.entity.Article;
import net.guerlab.smart.article.service.entity.ArticleCategory;
import net.guerlab.smart.article.service.service.ArticleConfigService;
import net.guerlab.smart.article.service.service.ArticleService;
import net.guerlab.smart.article.web.controller.AbstractArticleController;
import net.guerlab.smart.user.api.OperationLogApi;
import net.guerlab.smart.user.api.UserApi;
import net.guerlab.smart.user.auth.UserContextHandler;
import net.guerlab.smart.user.auth.annotation.HasPermission;
import net.guerlab.spring.commons.dto.DefaultConvertDTO;
import net.guerlab.spring.searchparams.AbstractSearchParams;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u6587\u7ae0"})
@RestController(value="/user/article")
@RequestMapping(value={"/user/article"})
public class ArticleController
extends AbstractArticleController<Article, ArticleService> {
    private ArticleConfigService configService;
    private OperationLogApi operationLogApi;
    private UserApi userApi;

    @ApiOperation(value="\u6dfb\u52a0")
    @PostMapping
    public ArticleDTO save(@ApiParam(value="\u5bf9\u8c61\u6570\u636e", required=true) @RequestBody ArticleDTO dto) {
        Article entity = new Article();
        BeanUtils.copyProperties((Object)dto, (Object)entity);
        if (this.needAudit()) {
            entity.setAuditStatus(AuditStatus.WAIT);
        } else {
            entity.setAuditStatus(AuditStatus.PASS);
        }
        ((ArticleService)this.getService()).insert((Object)entity);
        this.operationLogApi.add("\u6dfb\u52a0\u6587\u7ae0", UserContextHandler.getUserId(), new Object[]{entity});
        return entity.toDTO();
    }

    @ApiOperation(value="\u7f16\u8f91")
    @PutMapping(value={"/{id}"})
    public ArticleDTO update(@ApiParam(value="id", required=true) @PathVariable Long id, @ApiParam(value="\u5bf9\u8c61\u6570\u636e", required=true) @RequestBody ArticleDTO dto) {
        Article entity = (Article)((ArticleService)this.getService()).selectByIdOptional((Object)id).orElseThrow(ArticleInvalidException::new);
        entity.setArticleCategoryId(dto.getArticleCategoryId());
        entity.setSecondaryArticleCategoryIds(dto.getSecondaryArticleCategoryIds());
        entity.setTitle(dto.getTitle());
        entity.setCoverUrl(dto.getCoverUrl());
        entity.setAuthor(dto.getAuthor());
        entity.setReleaseTime(dto.getReleaseTime());
        entity.setSynopsis(dto.getSynopsis());
        entity.setContent(dto.getContent());
        entity.setOriginalLink(dto.getOriginalLink());
        entity.setAlwaysRedirect(dto.getAlwaysRedirect());
        entity.setPublishType(dto.getPublishType());
        entity.setPlanPublishTime(dto.getPlanPublishTime());
        entity.setAttachments(dto.getAttachments());
        entity.setOrderNum(dto.getOrderNum());
        if (this.needAudit()) {
            entity.setAuditStatus(AuditStatus.WAIT);
        } else {
            entity.setAuditStatus(AuditStatus.PASS);
        }
        ((ArticleService)this.getService()).updateSelectiveById((Object)entity);
        this.operationLogApi.add("\u7f16\u8f91\u6587\u7ae0", UserContextHandler.getUserId(), new Object[]{entity});
        return ((Article)((ArticleService)this.getService()).selectById((Object)id)).toDTO();
    }

    @ApiOperation(value="\u663e\u793a")
    @PutMapping(value={"/{id}/show"})
    public ArticleDTO show(@ApiParam(value="id", required=true) @PathVariable Long id) {
        Article entity = (Article)((ArticleService)this.getService()).selectByIdOptional((Object)id).orElseThrow(ArticleInvalidException::new);
        if (entity.getAuditStatus() != AuditStatus.PASS) {
            throw new ArticleAuditStatusErrorException();
        }
        entity.setPublished(Boolean.valueOf(true));
        entity.setPublishType(PublishType.MANUAL);
        entity.setPublishTime(LocalDateTime.now());
        ((ArticleService)this.getService()).updateSelectiveById((Object)entity);
        this.operationLogApi.add("\u663e\u793a\u6587\u7ae0", UserContextHandler.getUserId(), new Object[]{id});
        return ((Article)((ArticleService)this.getService()).selectById((Object)id)).toDTO();
    }

    @ApiOperation(value="\u4e0d\u663e\u793a")
    @PutMapping(value={"/{id}/unShow"})
    public ArticleDTO unShow(@ApiParam(value="id", required=true) @PathVariable Long id) {
        Article entity = (Article)((ArticleService)this.getService()).selectByIdOptional((Object)id).orElseThrow(ArticleInvalidException::new);
        entity.setPublished(Boolean.valueOf(false));
        entity.setPublishType(PublishType.MANUAL);
        ((ArticleService)this.getService()).updateSelectiveById((Object)entity);
        this.operationLogApi.add("\u9690\u85cf\u6587\u7ae0", UserContextHandler.getUserId(), new Object[]{id});
        return ((Article)((ArticleService)this.getService()).selectById((Object)id)).toDTO();
    }

    @ApiOperation(value="\u5220\u9664")
    @DeleteMapping(value={"/{id}"})
    public void delete(@ApiParam(value="id", required=true) @PathVariable Long id, @ApiParam(value="\u5f3a\u5236\u5220\u9664\u6807\u5fd7") @RequestParam(required=false) Boolean force) {
        ((ArticleService)this.getService()).selectByIdOptional((Object)id).orElseThrow(ArticleInvalidException::new);
        ((ArticleService)this.getService()).deleteById((Object)id, force);
        this.operationLogApi.add("\u5220\u9664\u6587\u7ae0", UserContextHandler.getUserId(), new Object[]{id});
    }

    @HasPermission(value={"ARTICLE_AUDIT"})
    @ApiOperation(value="\u5ba1\u6838\u901a\u8fc7")
    @PutMapping(value={"/{id}/audit/pass"})
    public ArticleDTO auditPass(@ApiParam(value="id", required=true) @PathVariable Long id) {
        Article entity = (Article)((ArticleService)this.getService()).selectByIdOptional((Object)id).orElseThrow(ArticleInvalidException::new);
        if (entity.getAuditStatus() != AuditStatus.WAIT) {
            throw new ArticleAuditStatusErrorException();
        }
        if (entity.getPublishType() == PublishType.AUTOMATIC) {
            entity.setPublished(Boolean.valueOf(true));
        } else if (entity.getPublishType() == PublishType.TIMING) {
            entity.setPublished(Boolean.valueOf(entity.getPlanPublishTime().isBefore(LocalDateTime.now())));
        }
        entity.setAuditStatus(AuditStatus.PASS);
        ((ArticleService)this.getService()).updateSelectiveById((Object)entity);
        this.operationLogApi.add("\u6587\u7ae0\u5ba1\u6838\u901a\u8fc7", UserContextHandler.getUserId(), new Object[]{id});
        return ((Article)((ArticleService)this.getService()).selectById((Object)id)).toDTO();
    }

    @HasPermission(value={"ARTICLE_AUDIT"})
    @ApiOperation(value="\u5ba1\u6838\u62d2\u7edd")
    @PutMapping(value={"/{id}/audit/refuse"})
    public ArticleDTO auditRefuse(@ApiParam(value="id", required=true) @PathVariable Long id) {
        Article entity = (Article)((ArticleService)this.getService()).selectByIdOptional((Object)id).orElseThrow(ArticleInvalidException::new);
        if (entity.getAuditStatus() != AuditStatus.WAIT) {
            throw new ArticleAuditStatusErrorException();
        }
        entity.setPublished(Boolean.valueOf(false));
        entity.setAuditStatus(AuditStatus.REFUSE);
        ((ArticleService)this.getService()).updateSelectiveById((Object)entity);
        this.operationLogApi.add("\u6587\u7ae0\u5ba1\u6838\u62d2\u7edd", UserContextHandler.getUserId(), new Object[]{id});
        return ((Article)((ArticleService)this.getService()).selectById((Object)id)).toDTO();
    }

    protected Article findOne0(String id) {
        Article article = (Article)super.findOne0(id);
        ArticleCategorySearchParams categorySearchParams = new ArticleCategorySearchParams();
        categorySearchParams.setArticleCategoryIds((Collection)article.getArticleCategoryIds());
        article.setCategories(this.getCategoryService().selectAll((AbstractSearchParams)categorySearchParams));
        return article;
    }

    protected void fillCategories(Collection<ArticleDTO> list) {
        if (list == null || list.isEmpty()) {
            return;
        }
        Collection allCategoryIds = list.stream().map(ArticleDTO::getArticleCategoryIds).flatMap(Collection::stream).collect(Collectors.toSet());
        if (allCategoryIds.isEmpty()) {
            return;
        }
        ArticleCategorySearchParams categorySearchParams = new ArticleCategorySearchParams();
        categorySearchParams.setArticleCategoryIds(allCategoryIds);
        Map categoryMap = CollectionUtil.toMap((Collection)this.getCategoryService().selectAll((AbstractSearchParams)categorySearchParams), ArticleCategory::getArticleCategoryId, DefaultConvertDTO::toDTO);
        list.forEach(article -> article.setCategories((Collection)article.getArticleCategoryIds().stream().map(categoryMap::get).filter(Objects::nonNull).collect(Collectors.toCollection(LinkedList::new))));
    }

    private boolean needAudit() {
        return this.enableAudit() && this.notHasAuditPermission();
    }

    private boolean enableAudit() {
        return this.configService.match("audit", "true");
    }

    private boolean notHasAuditPermission() {
        return !this.userApi.hasPermission(UserContextHandler.getUserId(), Collections.singletonList("ARTICLE_AUDIT"));
    }

    @Autowired
    public void setConfigService(ArticleConfigService configService) {
        this.configService = configService;
    }

    @Autowired
    public void setOperationLogApi(OperationLogApi operationLogApi) {
        this.operationLogApi = operationLogApi;
    }

    @Autowired
    public void setUserApi(UserApi userApi) {
        this.userApi = userApi;
    }
}

