/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.article.web.controller.commons;

import io.swagger.annotations.Api;
import java.util.Collection;
import net.guerlab.smart.article.core.enums.AuditStatus;
import net.guerlab.smart.article.core.exception.ArticleInvalidException;
import net.guerlab.smart.article.core.searchparams.ArticleCategorySearchParams;
import net.guerlab.smart.article.core.searchparams.ArticleSearchParams;
import net.guerlab.smart.article.service.entity.Article;
import net.guerlab.smart.article.service.service.ArticleService;
import net.guerlab.smart.article.web.controller.AbstractArticleController;
import net.guerlab.spring.searchparams.AbstractSearchParams;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u6587\u7ae0"})
@RestController(value="/commons/article")
@RequestMapping(value={"/commons/article"})
public class ArticleController
extends AbstractArticleController<Article, ArticleService> {
    protected void beforeFindList(ArticleSearchParams searchParams) {
        searchParams.setPublished(Boolean.valueOf(true));
        searchParams.setAuditStatus(AuditStatus.PASS);
    }

    protected Article findOne0(String id) {
        Article article = (Article)super.findOne0(id);
        if (!article.getPublished().booleanValue()) {
            throw new ArticleInvalidException();
        }
        ArticleCategorySearchParams categorySearchParams = new ArticleCategorySearchParams();
        categorySearchParams.setArticleCategoryIds((Collection)article.getArticleCategoryIds());
        article.setCategories(this.getCategoryService().selectAll((AbstractSearchParams)categorySearchParams));
        return article;
    }
}

