/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.article.web.controller.user;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.time.LocalDateTime;
import net.guerlab.smart.article.core.domain.ArticleDTO;
import net.guerlab.smart.article.core.enums.PublishType;
import net.guerlab.smart.article.core.exception.ArticleInvalidException;
import net.guerlab.smart.article.service.entity.Article;
import net.guerlab.smart.article.service.service.ArticleService;
import net.guerlab.smart.article.web.controller.AbstractArticleController;
import net.guerlab.smart.platform.user.api.OperationLogApi;
import net.guerlab.smart.platform.user.auth.UserContextHandler;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u6587\u7ae0"})
@RestController(value="/user/article")
@RequestMapping(value={"/user/article"})
public class ArticleController
extends AbstractArticleController<Article, ArticleService> {
    private OperationLogApi operationLogApi;

    @ApiOperation(value="\u6dfb\u52a0")
    @PostMapping
    public ArticleDTO save(@ApiParam(value="\u5bf9\u8c61\u6570\u636e", required=true) @RequestBody ArticleDTO dto) {
        Article entity = new Article();
        BeanUtils.copyProperties((Object)dto, (Object)entity);
        ((ArticleService)this.getService()).insert((Object)entity);
        this.operationLogApi.add("\u6dfb\u52a0\u6587\u7ae0", UserContextHandler.getUserId(), new Object[]{entity});
        return (ArticleDTO)entity.toDTO();
    }

    @ApiOperation(value="\u7f16\u8f91")
    @PutMapping(value={"/{id}"})
    public ArticleDTO update(@ApiParam(value="id", required=true) @PathVariable Long id, @ApiParam(value="\u5bf9\u8c61\u6570\u636e", required=true) @RequestBody ArticleDTO dto) {
        Article entity = (Article)((ArticleService)this.getService()).selectByIdOptional((Object)id).orElseThrow(ArticleInvalidException::new);
        entity.setArticleCategoryId(dto.getArticleCategoryId());
        entity.setTitle(dto.getTitle());
        entity.setCoverUrl(dto.getCoverUrl());
        entity.setAuthor(dto.getAuthor());
        entity.setReleaseTime(dto.getReleaseTime());
        entity.setSynopsis(dto.getSynopsis());
        entity.setContent(dto.getContent());
        entity.setOriginalLink(dto.getOriginalLink());
        entity.setAlwaysRedirect(dto.getAlwaysRedirect());
        entity.setPublishType(dto.getPublishType());
        entity.setPlanPublishTime(dto.getPlanPublishTime());
        ((ArticleService)this.getService()).updateSelectiveById((Object)entity);
        this.operationLogApi.add("\u7f16\u8f91\u6587\u7ae0", UserContextHandler.getUserId(), new Object[]{entity});
        return (ArticleDTO)((Article)((ArticleService)this.getService()).selectById((Object)id)).toDTO();
    }

    @ApiOperation(value="\u663e\u793a")
    @PutMapping(value={"/{id}/show"})
    public ArticleDTO show(@ApiParam(value="id", required=true) @PathVariable Long id) {
        Article entity = (Article)((ArticleService)this.getService()).selectByIdOptional((Object)id).orElseThrow(ArticleInvalidException::new);
        entity.setPublished(Boolean.valueOf(true));
        entity.setPublishType(PublishType.MANUAL);
        entity.setPublishTime(LocalDateTime.now());
        ((ArticleService)this.getService()).updateSelectiveById((Object)entity);
        this.operationLogApi.add("\u663e\u793a\u6587\u7ae0", UserContextHandler.getUserId(), new Object[]{id});
        return (ArticleDTO)((Article)((ArticleService)this.getService()).selectById((Object)id)).toDTO();
    }

    @ApiOperation(value="\u4e0d\u663e\u793a")
    @PutMapping(value={"/{id}/unShow"})
    public ArticleDTO unShow(@ApiParam(value="id", required=true) @PathVariable Long id) {
        Article entity = (Article)((ArticleService)this.getService()).selectByIdOptional((Object)id).orElseThrow(ArticleInvalidException::new);
        entity.setPublished(Boolean.valueOf(false));
        entity.setPublishType(PublishType.MANUAL);
        ((ArticleService)this.getService()).updateSelectiveById((Object)entity);
        this.operationLogApi.add("\u9690\u85cf\u6587\u7ae0", UserContextHandler.getUserId(), new Object[]{id});
        return (ArticleDTO)((Article)((ArticleService)this.getService()).selectById((Object)id)).toDTO();
    }

    @ApiOperation(value="\u5220\u9664")
    @DeleteMapping(value={"/{id}"})
    public void delete(@ApiParam(value="id", required=true) @PathVariable Long id, @ApiParam(value="\u5f3a\u5236\u5220\u9664\u6807\u5fd7") @RequestParam(required=false) Boolean force) {
        ((ArticleService)this.getService()).selectByIdOptional((Object)id).orElseThrow(ArticleInvalidException::new);
        ((ArticleService)this.getService()).deleteById((Object)id, force);
        this.operationLogApi.add("\u5220\u9664\u6587\u7ae0", UserContextHandler.getUserId(), new Object[]{id});
    }

    @Autowired
    public void setOperationLogApi(OperationLogApi operationLogApi) {
        this.operationLogApi = operationLogApi;
    }
}

