/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.article.web.controller.user;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.guerlab.commons.collection.CollectionUtil;
import net.guerlab.commons.exception.ApplicationException;
import net.guerlab.smart.article.core.domain.ArticleCategoryDTO;
import net.guerlab.smart.article.core.exception.ArticleCategoryInvalidException;
import net.guerlab.smart.article.core.searchparams.ArticleCategorySearchParams;
import net.guerlab.smart.article.service.entity.ArticleCategory;
import net.guerlab.smart.article.service.service.ArticleCategoryService;
import net.guerlab.smart.platform.commons.Constants;
import net.guerlab.smart.platform.commons.util.BeanConvertUtils;
import net.guerlab.smart.platform.server.controller.BaseController;
import net.guerlab.smart.platform.user.api.OperationLogApi;
import net.guerlab.smart.platform.user.auth.UserContextHandler;
import net.guerlab.spring.commons.dto.ConvertDTO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u6587\u7ae0\u5206\u7c7b"})
@RestController(value="/user/articleCategory")
@RequestMapping(value={"/user/articleCategory"})
public class ArticleCategoryController
extends BaseController<ArticleCategoryDTO, ArticleCategory, ArticleCategoryService, ArticleCategorySearchParams, Long> {
    private OperationLogApi operationLogApi;

    public void copyProperties(ArticleCategoryDTO dto, ArticleCategory entity, Long id) {
        super.copyProperties((Object)dto, (ConvertDTO)entity, (Object)id);
        entity.setArticleCategoryId(id);
    }

    protected ApplicationException nullPointException() {
        return new ArticleCategoryInvalidException();
    }

    @ApiOperation(value="\u83b7\u53d6\u6811\u72b6\u7ed3\u6784")
    @GetMapping(value={"/tree"})
    public List<ArticleCategoryDTO> tree() {
        List list = BeanConvertUtils.toList((Collection)((ArticleCategoryService)this.getService()).selectAll());
        Map map = CollectionUtil.group((Collection)list, ArticleCategoryDTO::getParentId);
        list.forEach(item -> item.setChildren((Collection)map.getOrDefault(item.getArticleCategoryId(), Collections.emptyList())));
        return (List)map.get(Constants.DEFAULT_PARENT_ID);
    }

    public void afterSave(ArticleCategory entity, ArticleCategoryDTO dto) {
        this.operationLogApi.add("\u6dfb\u52a0\u6587\u7ae0\u5206\u7c7b", UserContextHandler.getUserId(), new Object[]{entity});
    }

    public void afterUpdate(ArticleCategory entity, ArticleCategoryDTO dto) {
        this.operationLogApi.add("\u7f16\u8f91\u6587\u7ae0\u5206\u7c7b", UserContextHandler.getUserId(), new Object[]{entity});
    }

    public void afterDelete(ArticleCategory entity) {
        this.operationLogApi.add("\u5220\u9664\u6587\u7ae0\u5206\u7c7b", UserContextHandler.getUserId(), new Object[]{entity.getArticleCategoryId()});
    }

    @Autowired
    public void setOperationLogApi(OperationLogApi operationLogApi) {
        this.operationLogApi = operationLogApi;
    }
}

