/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.article.web.controller;

import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import net.guerlab.smart.article.core.domain.ArticleDTO;
import net.guerlab.smart.article.core.exception.ArticleInvalidException;
import net.guerlab.smart.article.core.searchparams.ArticleSearchParams;
import net.guerlab.smart.article.service.service.AbstractArticleService;
import net.guerlab.smart.platform.commons.util.BeanConvertUtils;
import net.guerlab.spring.commons.dto.ConvertDTO;
import net.guerlab.spring.searchparams.AbstractSearchParams;
import net.guerlab.web.result.ListObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;

public abstract class AbstractArticleController<E extends ConvertDTO<ArticleDTO>, S extends AbstractArticleService<E, Long>> {
    protected S service;

    @ApiOperation(value="\u67e5\u8be2\u8be6\u60c5")
    @GetMapping(value={"/{id}"})
    public ArticleDTO findOne(@ApiParam(value="\u6587\u7ae0ID/\u552f\u4e00key", required=true) @PathVariable String id) {
        return (ArticleDTO)this.findOne0(id).toDTO();
    }

    protected E findOne0(String id) {
        ConvertDTO article = Pattern.matches("^(-?\\d*)$", id) ? (ConvertDTO)this.service.selectById((Object)Long.parseLong(id)) : this.service.selectByUniqueKey(id);
        if (article == null) {
            throw new ArticleInvalidException();
        }
        return (E)article;
    }

    @ApiOperation(value="\u67e5\u8be2\u5217\u8868")
    @GetMapping
    public ListObject<ArticleDTO> findList(ArticleSearchParams searchParams) {
        this.beforeFindList(searchParams);
        return BeanConvertUtils.toListObject((ListObject)this.service.selectPage((AbstractSearchParams)searchParams));
    }

    @ApiOperation(value="\u67e5\u8be2\u5168\u90e8")
    @GetMapping(value={"/all"})
    public List<ArticleDTO> findAll(ArticleSearchParams searchParams) {
        this.beforeFindList(searchParams);
        return BeanConvertUtils.toList((Collection)this.service.selectAll((AbstractSearchParams)searchParams));
    }

    protected void beforeFindList(ArticleSearchParams searchParams) {
    }

    public S getService() {
        return this.service;
    }

    @Autowired
    public void setService(S service) {
        this.service = service;
    }
}

