package net.guerlab.smart.article.web.controller.user;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import net.guerlab.commons.collection.CollectionUtil;
import net.guerlab.commons.exception.ApplicationException;
import net.guerlab.smart.article.core.domain.ArticleCategoryDTO;
import net.guerlab.smart.article.core.exception.ArticleCategoryInvalidException;
import net.guerlab.smart.article.core.searchparams.ArticleCategorySearchParams;
import net.guerlab.smart.article.service.entity.ArticleCategory;
import net.guerlab.smart.article.service.service.ArticleCategoryService;
import net.guerlab.smart.platform.commons.Constants;
import net.guerlab.smart.platform.commons.util.BeanConvertUtils;
import net.guerlab.smart.platform.server.controller.BaseController;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.Collections;
import java.util.List;
import java.util.Map;

/**
 * 文章分类
 *
 * @author guer
 */
@Api(tags = "文章分类")
@RestController("/user/articleCategory")
@RequestMapping("/user/articleCategory")
public class ArticleCategoryController
        extends BaseController<ArticleCategoryDTO, ArticleCategory, ArticleCategoryService, ArticleCategorySearchParams, Long> {

    @Override
    public void copyProperties(ArticleCategoryDTO dto, ArticleCategory entity, Long id) {
        super.copyProperties(dto, entity, id);
        entity.setArticleCategoryId(id);
    }

    @Override
    protected ApplicationException nullPointException() {
        return new ArticleCategoryInvalidException();
    }

    @ApiOperation("获取树状结构")
    @GetMapping("/tree")
    public List<ArticleCategoryDTO> tree() {
        List<ArticleCategoryDTO> list = BeanConvertUtils.toList(getService().selectAll());
        Map<Long, List<ArticleCategoryDTO>> map = CollectionUtil.group(list, ArticleCategoryDTO::getParentId);

        list.forEach(item -> item.setChildren(map.getOrDefault(item.getArticleCategoryId(), Collections.emptyList())));

        return map.get(Constants.DEFAULT_PARENT_ID);
    }
}
