package net.guerlab.smart.article.web.controller.user;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import net.guerlab.smart.article.core.domain.ArticleDTO;
import net.guerlab.smart.article.core.enums.PublishType;
import net.guerlab.smart.article.core.exception.ArticleInvalidException;
import net.guerlab.smart.article.service.entity.Article;
import net.guerlab.smart.article.service.service.ArticleService;
import net.guerlab.smart.article.web.controller.AbstractArticleController;
import org.springframework.beans.BeanUtils;
import org.springframework.web.bind.annotation.*;

import java.time.LocalDateTime;

/**
 * 文章
 *
 * @author guer
 */
@Api(tags = "文章")
@RestController("/user/article")
@RequestMapping("/user/article")
public class ArticleController extends AbstractArticleController<Article, ArticleService> {

    @ApiOperation("添加")
    @PostMapping
    public ArticleDTO save(@ApiParam(value = "对象数据", required = true) @RequestBody ArticleDTO dto) {
        Article entity = new Article();
        BeanUtils.copyProperties(dto, entity);
        getService().insert(entity);
        return entity.toDTO();
    }

    @ApiOperation("编辑")
    @PutMapping("/{id}")
    public ArticleDTO update(@ApiParam(value = "id", required = true) @PathVariable Long id,
            @ApiParam(value = "对象数据", required = true) @RequestBody ArticleDTO dto) {
        Article entity = getService().selectByIdOptional(id).orElseThrow(ArticleInvalidException::new);

        entity.setArticleCategoryId(dto.getArticleCategoryId());
        entity.setTitle(dto.getTitle());
        entity.setCoverUrl(dto.getCoverUrl());
        entity.setAuthor(dto.getAuthor());
        entity.setReleaseTime(dto.getReleaseTime());
        entity.setSynopsis(dto.getSynopsis());
        entity.setContent(dto.getContent());
        entity.setOriginalLink(dto.getOriginalLink());
        entity.setAlwaysRedirect(dto.getAlwaysRedirect());
        entity.setPublishType(dto.getPublishType());
        entity.setPlanPublishTime(dto.getPlanPublishTime());

        getService().updateSelectiveById(entity);
        return getService().selectById(id).toDTO();
    }

    @ApiOperation("显示")
    @PutMapping("/{id}/show")
    public ArticleDTO show(@ApiParam(value = "id", required = true) @PathVariable Long id) {
        Article entity = getService().selectByIdOptional(id).orElseThrow(ArticleInvalidException::new);
        entity.setPublished(true);
        entity.setPublishType(PublishType.MANUAL);
        entity.setPublishTime(LocalDateTime.now());
        getService().updateSelectiveById(entity);
        return getService().selectById(id).toDTO();
    }

    @ApiOperation("不显示")
    @PutMapping("/{id}/unShow")
    public ArticleDTO unShow(@ApiParam(value = "id", required = true) @PathVariable Long id) {
        Article entity = getService().selectByIdOptional(id).orElseThrow(ArticleInvalidException::new);
        entity.setPublished(false);
        entity.setPublishType(PublishType.MANUAL);
        getService().updateSelectiveById(entity);
        return getService().selectById(id).toDTO();
    }

    @ApiOperation("删除")
    @DeleteMapping("/{id}")
    public void delete(@ApiParam(value = "id", required = true) @PathVariable Long id,
            @ApiParam(value = "强制删除标志") @RequestParam(required = false) Boolean force) {
        getService().selectByIdOptional(id).orElseThrow(ArticleInvalidException::new);
        getService().deleteById(id, force);
    }
}
