package net.guerlab.smart.article.web.controller.commons;

import io.swagger.annotations.Api;
import net.guerlab.smart.article.core.domain.ArticleDTO;
import net.guerlab.smart.article.core.exception.ArticleInvalidException;
import net.guerlab.smart.article.core.searchparams.ArticleSearchParams;
import net.guerlab.smart.article.service.entity.SimpleArticle;
import net.guerlab.smart.article.service.service.SimpleArticleService;
import net.guerlab.smart.article.web.controller.AbstractArticleController;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 简单文章
 *
 * @author guer
 */
@Api(tags = "简单文章")
@RestController("/commons/simpleArticle")
@RequestMapping("/commons/simpleArticle")
public class SimpleArticleController extends AbstractArticleController<SimpleArticle, SimpleArticleService> {

    @Override
    protected void beforeFindList(ArticleSearchParams searchParams) {
        searchParams.setPublished(true);
    }

    @Override
    public ArticleDTO findOne(String id) {
        ArticleDTO dto = super.findOne(id);

        if (!dto.getPublished()) {
            throw new ArticleInvalidException();
        }

        return dto;
    }
}
