package net.guerlab.smart.article.web.controller.user;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import net.guerlab.smart.article.core.domain.ArticleDTO;
import net.guerlab.smart.article.core.exception.ArticleInvalidException;
import net.guerlab.smart.article.service.entity.Article;
import net.guerlab.smart.article.service.service.ArticleService;
import net.guerlab.smart.article.web.controller.AbstractArticleController;
import org.springframework.beans.BeanUtils;
import org.springframework.web.bind.annotation.*;

/**
 * 文章
 *
 * @author guer
 */
@Api(tags = "文章")
@RestController("/user/article")
@RequestMapping("/user/article")
public class ArticleController extends AbstractArticleController<Article, ArticleService> {

    @ApiOperation("添加")
    @PostMapping
    public ArticleDTO save(@ApiParam(value = "对象数据", required = true) @RequestBody ArticleDTO dto) {
        Article entity = new Article();
        BeanUtils.copyProperties(dto, entity);
        getService().insert(entity);
        return entity.toDTO();
    }

    @ApiOperation("编辑")
    @PutMapping("/{id}")
    public ArticleDTO update(@ApiParam(value = "id", required = true) @PathVariable Long id,
            @ApiParam(value = "对象数据", required = true) @RequestBody ArticleDTO dto) {
        Article entity = getService().selectByIdOptional(id).orElseThrow(ArticleInvalidException::new);
        BeanUtils.copyProperties(dto, entity);
        entity.setArticleId(id);
        getService().updateSelectiveById(entity);
        return getService().selectById(id).toDTO();
    }

    @ApiOperation("删除")
    @DeleteMapping("/{id}")
    public void delete(@ApiParam(value = "id", required = true) @PathVariable Long id,
            @ApiParam(value = "强制删除标志") @RequestParam(required = false) Boolean force) {
        getService().selectByIdOptional(id).orElseThrow(ArticleInvalidException::new);
        getService().deleteById(id, force);
    }
}
