package net.guerlab.smart.article.web.controller.user;

import io.swagger.annotations.Api;
import net.guerlab.commons.exception.ApplicationException;
import net.guerlab.smart.article.core.domain.ArticleCategoryDTO;
import net.guerlab.smart.article.core.exception.ArticleCategoryInvalidException;
import net.guerlab.smart.article.core.searchparams.ArticleCategorySearchParams;
import net.guerlab.smart.article.service.entity.ArticleCategory;
import net.guerlab.smart.article.service.service.ArticleCategoryService;
import net.guerlab.smart.platform.server.controller.BaseController;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 文章分类
 *
 * @author guer
 */
@Api(tags = "文章分类")
@RestController("/user/articleCategory")
@RequestMapping("/user/articleCategory")
public class ArticleCategoryController
        extends BaseController<ArticleCategoryDTO, ArticleCategory, ArticleCategoryService, ArticleCategorySearchParams, Long> {

    @Override
    public void copyProperties(ArticleCategoryDTO dto, ArticleCategory entity, Long id) {
        super.copyProperties(dto, entity, id);
        entity.setArticleCategoryId(id);
    }

    @Override
    protected ApplicationException nullPointException() {
        return new ArticleCategoryInvalidException();
    }
}
