package net.guerlab.smart.article.web.controller;

import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import net.guerlab.smart.article.core.domain.ArticleDTO;
import net.guerlab.smart.article.core.exception.ArticleInvalidException;
import net.guerlab.smart.article.core.searchparams.ArticleSearchParams;
import net.guerlab.smart.article.service.service.AbstractArticleService;
import net.guerlab.smart.platform.commons.util.BeanConvertUtils;
import net.guerlab.spring.commons.dto.ConvertDTO;
import net.guerlab.web.result.ListObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;

import java.util.List;
import java.util.regex.Pattern;

/**
 * 抽象文章查询
 *
 * @author guer
 */
public abstract class AbstractArticleController<E extends ConvertDTO<ArticleDTO>, S extends AbstractArticleService<E, Long>> {

    protected S service;

    @ApiOperation("查询详情")
    @GetMapping("/{id}")
    public ArticleDTO findOne(@ApiParam(value = "文章ID/唯一key", required = true) @PathVariable String id) {
        E article;
        if (Pattern.matches(AbstractArticleService.NUMBER_REG, id)) {
            article = service.selectById(Long.parseLong(id));
        } else {
            article = service.selectByUniqueKey(id);
        }

        if (article == null) {
            throw new ArticleInvalidException();
        }

        return article.toDTO();
    }

    @ApiOperation("查询列表")
    @GetMapping
    public ListObject<ArticleDTO> findList(ArticleSearchParams searchParams) {
        return BeanConvertUtils.toListObject(service.selectPage(searchParams));
    }

    @ApiOperation("查询全部")
    @GetMapping("/all")
    public List<ArticleDTO> findAll(ArticleSearchParams searchParams) {
        return BeanConvertUtils.toList(service.selectAll(searchParams));
    }

    public S getService() {
        return this.service;
    }

    @Autowired
    public void setService(S service) {
        this.service = service;
    }
}
