/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.article.service.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.guerlab.commons.collection.CollectionUtil;
import net.guerlab.commons.number.NumberHelper;
import net.guerlab.smart.article.core.eneity.Attachments;
import net.guerlab.smart.article.core.enums.AuditStatus;
import net.guerlab.smart.article.core.enums.PublishType;
import net.guerlab.smart.article.core.exception.ArticleCategoryIdInvalidException;
import net.guerlab.smart.article.core.exception.ArticleCategoryInvalidException;
import net.guerlab.smart.article.core.exception.ArticleTitleInvalidException;
import net.guerlab.smart.article.core.exception.ArticleTitleLengthErrorException;
import net.guerlab.smart.article.core.exception.AuthorLengthErrorException;
import net.guerlab.smart.article.core.exception.DescriptionLengthErrorException;
import net.guerlab.smart.article.core.exception.KeywordsLengthErrorException;
import net.guerlab.smart.article.core.exception.OriginalLinkLengthErrorException;
import net.guerlab.smart.article.core.exception.PlanPublishTimeInvalidException;
import net.guerlab.smart.article.core.exception.SynopsisLengthErrorException;
import net.guerlab.smart.article.core.exception.UniqueKeyFormatErrorException;
import net.guerlab.smart.article.core.exception.UniqueKeyLengthErrorException;
import net.guerlab.smart.article.core.exception.UniqueKeyRepeatException;
import net.guerlab.smart.article.core.searchparams.ArticleCategoryMappingSearchParams;
import net.guerlab.smart.article.core.searchparams.ArticleCategorySearchParams;
import net.guerlab.smart.article.core.searchparams.ArticleSearchParams;
import net.guerlab.smart.article.service.entity.Article;
import net.guerlab.smart.article.service.entity.ArticleCategory;
import net.guerlab.smart.article.service.entity.ArticleCategoryMapping;
import net.guerlab.smart.article.service.handlers.ArticleCategoryUpdateAfterHandler;
import net.guerlab.smart.article.service.mapper.ArticleMapper;
import net.guerlab.smart.article.service.service.ArticleService;
import net.guerlab.smart.article.service.service.impl.AbstractArticleServiceImpl;
import net.guerlab.smart.platform.commons.domain.MultiId;
import net.guerlab.smart.platform.commons.entity.IOrderEntity;
import net.guerlab.smart.platform.commons.util.OrderEntityUtils;
import net.guerlab.spring.searchparams.AbstractSearchParams;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class ArticleServiceImpl
extends AbstractArticleServiceImpl<Article, ArticleMapper>
implements ArticleService,
ArticleCategoryUpdateAfterHandler {
    @Override
    public void articleCategoryUpdateAfterHandler(ArticleCategory articleCategory) {
        String categoryType;
        String categoryName;
        Long categoryId = articleCategory.getArticleCategoryId();
        if (this.refuseUpdateArticleCategory(categoryId, categoryName = StringUtils.trimToNull((String)articleCategory.getArticleCategoryName()), categoryType = StringUtils.trimToNull((String)articleCategory.getArticleCategoryType()))) {
            return;
        }
        Article entity = new Article();
        entity.setArticleCategoryName(categoryName);
        entity.setArticleCategoryType(categoryType);
        ArticleSearchParams searchParams = new ArticleSearchParams();
        searchParams.setArticleCategoryId(categoryId);
        ((ArticleMapper)this.getBaseMapper()).update((Object)entity, (Wrapper)this.getQueryWrapper((AbstractSearchParams)searchParams));
    }

    private boolean refuseUpdateArticleCategory(Long categoryId, String categoryName, String categoryType) {
        return !NumberHelper.greaterZero((Number)categoryId) || categoryName == null && categoryType == null;
    }

    @Override
    public void addViewNumber(Long articleId) {
        if (!NumberHelper.greaterZero((Number)articleId)) {
            return;
        }
        ((ArticleMapper)this.getBaseMapper()).addViewNumber(articleId);
    }

    protected void insertBefore(Article entity) {
        PublishType publishType;
        String title = StringUtils.trimToNull((String)entity.getTitle());
        if (title == null) {
            throw new ArticleTitleInvalidException();
        }
        if (title.length() > 255) {
            throw new ArticleTitleLengthErrorException();
        }
        entity.setTitle(title);
        String keywords = StringUtils.trimToEmpty((String)entity.getKeywords());
        if (keywords.length() > 255) {
            throw new KeywordsLengthErrorException();
        }
        entity.setKeywords(keywords);
        String description = StringUtils.trimToEmpty((String)entity.getDescription());
        if (description.length() > 255) {
            throw new DescriptionLengthErrorException();
        }
        entity.setDescription(description);
        this.setCoverUrl(entity);
        this.setAuthor(entity);
        this.setSynopsis(entity);
        this.setOriginalLink(entity);
        this.setUniqueKey(entity);
        entity.setContent(StringUtils.trimToEmpty((String)entity.getContent()));
        ArticleCategory articleCategory = this.findArticleCategory(entity.getArticleCategoryId());
        entity.setArticleCategoryName(articleCategory.getArticleCategoryName());
        entity.setArticleCategoryType(articleCategory.getArticleCategoryType());
        this.articleCategoryIdsFieldHandler(entity);
        LocalDateTime now = LocalDateTime.now();
        if (entity.getReleaseTime() == null) {
            entity.setReleaseTime(now);
        }
        if (entity.getAlwaysRedirect() == null) {
            entity.setAlwaysRedirect(false);
        }
        if ((publishType = entity.getPublishType()) == null) {
            publishType = PublishType.AUTOMATIC;
        }
        entity.setPublishType(publishType);
        Attachments attachments = entity.getAttachments();
        if (attachments != null) {
            attachments = attachments.stream().filter(Objects::nonNull).collect(Collectors.toCollection(Attachments::new));
            entity.setAttachments(attachments);
            entity.setHasAttachment(!attachments.isEmpty());
        } else {
            entity.setAttachments(new Attachments());
            entity.setHasAttachment(false);
        }
        entity.setArticleId(this.sequence.nextId());
        entity.setCreateTime(now);
        entity.setUpdateTime(now);
        if (entity.getAuditStatus() == null) {
            entity.setAuditStatus(AuditStatus.WAIT);
        }
        OrderEntityUtils.propertiesCheck((IOrderEntity)entity);
        entity.setViewNumber(0L);
        this.setPublishType(entity, publishType, now);
    }

    protected void insertAfter(Article entity) {
        this.saveArticleCategoryMappings(entity);
    }

    private void setUniqueKey(Article entity) {
        String uniqueKey = StringUtils.trimToNull((String)entity.getUniqueKey());
        if (uniqueKey != null) {
            if (uniqueKey.length() > 50) {
                throw new UniqueKeyLengthErrorException();
            }
            if (Pattern.matches("^(-?\\d*)$", uniqueKey)) {
                throw new UniqueKeyFormatErrorException();
            }
            if (this.selectByUniqueKey(uniqueKey) != null) {
                throw new UniqueKeyRepeatException();
            }
        } else {
            uniqueKey = "";
        }
        entity.setUniqueKey(uniqueKey);
    }

    protected void updateBefore(Article entity) {
        Attachments attachments;
        String title = StringUtils.trimToNull((String)entity.getTitle());
        if (title != null && title.length() > 255) {
            throw new ArticleTitleLengthErrorException();
        }
        entity.setTitle(title);
        String keywords = StringUtils.trim((String)entity.getKeywords());
        if (keywords != null && keywords.length() > 255) {
            throw new KeywordsLengthErrorException();
        }
        entity.setKeywords(keywords);
        String description = StringUtils.trim((String)entity.getDescription());
        if (description != null && description.length() > 255) {
            throw new DescriptionLengthErrorException();
        }
        entity.setDescription(description);
        entity.setKeywords(StringUtils.trim((String)entity.getKeywords()));
        entity.setDescription(StringUtils.trim((String)entity.getDescription()));
        this.setCoverUrl(entity);
        this.setAuthor(entity);
        this.setSynopsis(entity);
        this.setOriginalLink(entity);
        ArticleCategory articleCategory = this.findArticleCategory(entity.getArticleCategoryId());
        entity.setArticleCategoryName(articleCategory.getArticleCategoryName());
        entity.setArticleCategoryType(articleCategory.getArticleCategoryType());
        this.articleCategoryIdsFieldHandler(entity);
        PublishType publishType = entity.getPublishType();
        LocalDateTime now = LocalDateTime.now();
        if (publishType != null) {
            this.setPublishType(entity, publishType, now);
        }
        if ((attachments = entity.getAttachments()) != null) {
            attachments = attachments.stream().filter(Objects::nonNull).collect(Collectors.toCollection(Attachments::new));
            entity.setAttachments(attachments);
            entity.setHasAttachment(!attachments.isEmpty());
        } else {
            entity.setAttachments(null);
            entity.setHasAttachment(null);
        }
        entity.setUpdateTime(now);
    }

    protected void updateAfter(Article entity) {
        ArticleCategoryMappingSearchParams searchParams = new ArticleCategoryMappingSearchParams();
        searchParams.setArticleId(entity.getArticleId());
        this.getMappingService().delete(searchParams);
        this.saveArticleCategoryMappings(entity);
    }

    private void saveArticleCategoryMappings(Article entity) {
        Long articleId = entity.getArticleId();
        MultiId articleCategoryIds = entity.getArticleCategoryIds();
        Collection mappings = articleCategoryIds.stream().map(categoryId -> new ArticleCategoryMapping(articleId, (Long)categoryId)).collect(Collectors.toList());
        this.getMappingService().save(mappings);
    }

    private void articleCategoryIdsFieldHandler(Article entity) {
        Long articleCategoryId = entity.getArticleCategoryId();
        if (entity.getSecondaryArticleCategoryIds() != null) {
            entity.getSecondaryArticleCategoryIds().remove((Object)articleCategoryId);
        }
        MultiId secondaryArticleCategoryIds = this.findArticleCategoryIds((Collection<Long>)entity.getSecondaryArticleCategoryIds());
        MultiId articleCategoryIds = new MultiId();
        articleCategoryIds.add((Object)articleCategoryId);
        articleCategoryIds.addAll((Collection)secondaryArticleCategoryIds);
        entity.setSecondaryArticleCategoryIds(secondaryArticleCategoryIds);
        entity.setArticleCategoryIds(articleCategoryIds);
    }

    private void setCoverUrl(Article entity) {
        String coverUrl = StringUtils.trimToEmpty((String)entity.getCoverUrl());
        entity.setCoverUrl(coverUrl);
        entity.setHasCoverUrl(!coverUrl.isEmpty());
    }

    private void setAuthor(Article entity) {
        String author = StringUtils.trimToEmpty((String)entity.getAuthor());
        if (author.length() > 100) {
            throw new AuthorLengthErrorException();
        }
        entity.setAuthor(author);
    }

    private void setSynopsis(Article entity) {
        String synopsis = StringUtils.trimToEmpty((String)entity.getSynopsis());
        if (synopsis.length() > 255) {
            throw new SynopsisLengthErrorException();
        }
        entity.setSynopsis(synopsis);
    }

    private void setOriginalLink(Article entity) {
        String originalLink = StringUtils.trimToEmpty((String)entity.getOriginalLink());
        if (originalLink.length() > 255) {
            throw new OriginalLinkLengthErrorException();
        }
        entity.setOriginalLink(originalLink);
    }

    private void setPublishType(Article entity, PublishType publishType, LocalDateTime now) {
        boolean passAudit = entity.getAuditStatus() == AuditStatus.PASS;
        switch (publishType) {
            case AUTOMATIC: {
                entity.setPlanPublishTime(now);
                entity.setPublishTime(now);
                entity.setPublished(passAudit);
                break;
            }
            case TIMING: {
                LocalDateTime planPublishTime = entity.getPlanPublishTime();
                if (planPublishTime == null) {
                    throw new PlanPublishTimeInvalidException();
                }
                if (planPublishTime.isBefore(now)) {
                    entity.setPublished(passAudit);
                    entity.setPublishTime(now);
                    break;
                }
                entity.setPublishTime(null);
                entity.setPublished(false);
                break;
            }
            case MANUAL: {
                if (entity.getPublished() == null) {
                    entity.setPlanPublishTime(null);
                    entity.setPublishTime(null);
                    break;
                }
                if (entity.getPublished().booleanValue()) {
                    entity.setPlanPublishTime(now);
                    entity.setPublishTime(now);
                    break;
                }
                entity.setPlanPublishTime(now);
                entity.setPublishTime(now);
                break;
            }
        }
    }

    private ArticleCategory findArticleCategory(Long articleCategoryId) {
        if (!NumberHelper.greaterZero((Number)articleCategoryId)) {
            throw new ArticleCategoryIdInvalidException();
        }
        return (ArticleCategory)((Object)this.getCategoryService().selectByIdOptional(articleCategoryId).orElseThrow(ArticleCategoryInvalidException::new));
    }

    private MultiId findArticleCategoryIds(Collection<Long> articleCategoryIds) {
        if (articleCategoryIds == null || articleCategoryIds.isEmpty()) {
            return new MultiId();
        }
        ArticleCategorySearchParams searchParams = new ArticleCategorySearchParams();
        searchParams.setArticleCategoryIds(articleCategoryIds);
        MultiId multiId = new MultiId();
        multiId.addAll((Collection)CollectionUtil.toSet((Collection)this.getCategoryService().selectAll((AbstractSearchParams)searchParams), ArticleCategory::getArticleCategoryId));
        return multiId;
    }
}

