/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.article.service.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.guerlab.commons.collection.CollectionUtil;
import net.guerlab.smart.article.core.searchparams.ArticleConfigSearchParams;
import net.guerlab.smart.article.service.entity.ArticleConfig;
import net.guerlab.smart.article.service.mapper.ArticleConfigMapper;
import net.guerlab.smart.article.service.service.ArticleConfigService;
import net.guerlab.smart.platform.server.service.BaseServiceImpl;
import net.guerlab.spring.searchparams.AbstractSearchParams;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class ArticleConfigServiceImpl
extends BaseServiceImpl<ArticleConfig, String, ArticleConfigMapper, ArticleConfigSearchParams>
implements ArticleConfigService {
    @Override
    public String findOne(String key) {
        if ((key = StringUtils.trimToNull((String)key)) == null) {
            return null;
        }
        ArticleConfig config = (ArticleConfig)((ArticleConfigMapper)this.getBaseMapper()).selectById((Serializable)((Object)key));
        return config == null ? null : config.getConfigValue();
    }

    @Override
    public Map<String, String> findMap(Collection<String> keys) {
        List<String> keyList = this.keysFilter(keys);
        if (keyList.isEmpty()) {
            return Collections.emptyMap();
        }
        ArticleConfigSearchParams searchParams = new ArticleConfigSearchParams();
        searchParams.setConfigKeys(keyList);
        return CollectionUtil.toMap((Collection)this.selectAll((AbstractSearchParams)searchParams), ArticleConfig::getConfigKey, ArticleConfig::getConfigValue);
    }

    @Override
    public Map<String, String> findAll() {
        return CollectionUtil.toMap((Collection)this.selectAll(), ArticleConfig::getConfigKey, ArticleConfig::getConfigValue);
    }

    @Override
    public void save(Map<String, String> configs) {
        if (configs == null || configs.isEmpty()) {
            return;
        }
        List configList = configs.entrySet().stream().map(this::buildConfig).filter(Objects::nonNull).collect(Collectors.toList());
        if (configList.isEmpty()) {
            return;
        }
        ((ArticleConfigMapper)this.getBaseMapper()).replaceInsertList(configList);
    }

    @Override
    public void delete(Collection<String> keys) {
        List<String> keyList = this.keysFilter(keys);
        if (keyList.isEmpty()) {
            return;
        }
        ArticleConfigSearchParams searchParams = new ArticleConfigSearchParams();
        searchParams.setConfigKeys(keyList);
        ((ArticleConfigMapper)this.getBaseMapper()).delete((Wrapper)this.getQueryWrapper((AbstractSearchParams)searchParams));
    }

    private List<String> keysFilter(Collection<String> keys) {
        if (keys == null || keys.isEmpty()) {
            return Collections.emptyList();
        }
        return keys.stream().map(StringUtils::trimToNull).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private ArticleConfig buildConfig(Map.Entry<String, String> entry) {
        if (entry == null) {
            return null;
        }
        String key = StringUtils.trimToNull((String)entry.getKey());
        String value = StringUtils.trimToNull((String)entry.getValue());
        if (key == null || key.length() > 100 || value == null || value.length() > 255) {
            return null;
        }
        ArticleConfig config = new ArticleConfig();
        config.setConfigKey(key);
        config.setConfigValue(value);
        return config;
    }

    public Class<ArticleConfig> getEntityClass() {
        return ArticleConfig.class;
    }
}

