/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.article.service.service.impl;

import java.util.Optional;
import net.guerlab.commons.number.NumberHelper;
import net.guerlab.smart.article.core.exception.ArticleCategoryNameInvalidException;
import net.guerlab.smart.article.core.exception.ArticleCategoryNameLengthErrorException;
import net.guerlab.smart.article.core.exception.DetailPageTypeLengthErrorException;
import net.guerlab.smart.article.core.exception.ListPageTypeLengthErrorException;
import net.guerlab.smart.article.core.exception.ParentArticleCategoryInvalidException;
import net.guerlab.smart.article.core.searchparams.ArticleCategorySearchParams;
import net.guerlab.smart.article.service.entity.ArticleCategory;
import net.guerlab.smart.article.service.handlers.ArticleCategoryDeleteAfterHandler;
import net.guerlab.smart.article.service.handlers.ArticleCategoryUpdateAfterHandler;
import net.guerlab.smart.article.service.mapper.ArticleCategoryMapper;
import net.guerlab.smart.article.service.service.ArticleCategoryService;
import net.guerlab.smart.platform.commons.Constants;
import net.guerlab.smart.platform.commons.entity.IOrderEntity;
import net.guerlab.smart.platform.commons.util.OrderEntityUtils;
import net.guerlab.smart.platform.server.service.BaseServiceImpl;
import net.guerlab.spring.commons.util.SpringApplicationContextUtil;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class ArticleCategoryServiceImpl
extends BaseServiceImpl<ArticleCategory, Long, ArticleCategoryMapper, ArticleCategorySearchParams>
implements ArticleCategoryService {
    protected void insertBefore(ArticleCategory entity) {
        String name = StringUtils.trimToNull((String)entity.getArticleCategoryName());
        String type = StringUtils.trimToNull((String)entity.getArticleCategoryType());
        Long parentId = entity.getParentId();
        String listPageType = StringUtils.trimToEmpty((String)entity.getListPageType());
        String detailPageType = StringUtils.trimToEmpty((String)entity.getDetailPageType());
        if (name == null) {
            throw new ArticleCategoryNameInvalidException();
        }
        if (name.length() > 100) {
            throw new ArticleCategoryNameLengthErrorException();
        }
        if (NumberHelper.greaterZero((Number)parentId)) {
            if (this.selectById(parentId) == null) {
                throw new ParentArticleCategoryInvalidException();
            }
        } else {
            entity.setParentId(Constants.DEFAULT_PARENT_ID);
        }
        if (listPageType.length() > 100) {
            throw new ListPageTypeLengthErrorException();
        }
        if (detailPageType.length() > 100) {
            throw new DetailPageTypeLengthErrorException();
        }
        entity.setArticleCategoryId(this.sequence.nextId());
        entity.setArticleCategoryName(name);
        entity.setArticleCategoryType(Optional.ofNullable(type).orElse("general"));
        if (entity.getEnabled() == null) {
            entity.setEnabled(true);
        }
        if (entity.getDisplay() == null) {
            entity.setDisplay(true);
        }
        entity.setListPageType(listPageType);
        entity.setDetailPageType(detailPageType);
        OrderEntityUtils.propertiesCheck((IOrderEntity)entity);
    }

    protected void updateBefore(ArticleCategory entity) {
        String name = StringUtils.trimToNull((String)entity.getArticleCategoryName());
        if (name != null && name.length() > 100) {
            throw new ArticleCategoryNameLengthErrorException();
        }
        entity.setArticleCategoryName(name);
        String listPageType = StringUtils.trimToNull((String)entity.getListPageType());
        if (listPageType != null && listPageType.length() > 100) {
            throw new ListPageTypeLengthErrorException();
        }
        String detailPageType = StringUtils.trimToNull((String)entity.getDetailPageType());
        if (detailPageType != null && detailPageType.length() > 100) {
            throw new DetailPageTypeLengthErrorException();
        }
    }

    protected void updateAfter(ArticleCategory entity) {
        SpringApplicationContextUtil.getContext().getBeansOfType(ArticleCategoryUpdateAfterHandler.class).values().forEach(handler -> handler.articleCategoryUpdateAfterHandler(entity));
    }

    protected void deleteAfter(ArticleCategorySearchParams searchParams, Boolean force) {
        this.deleteByIdAfter(searchParams.getArticleCategoryId(), force);
    }

    protected void deleteByIdAfter(Long id, Boolean force) {
        SpringApplicationContextUtil.getContext().getBeansOfType(ArticleCategoryDeleteAfterHandler.class).values().forEach(handler -> handler.articleCategoryDeleteAfterHandler(id));
    }
}

